/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.raytrace;

import java.util.HashMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.Vector;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.raytrace.Raytrace;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RaytraceWorld
extends Raytrace {
    private static final int MAX_BLOCKS = 200;
    private World world;
    private Vector step;
    private BlockPos blockSrc;
    private BlockPos blockDest;
    public HashMap<BlockPos, RayTraceResult> blockPassed;
    public int options = 0;

    public RaytraceWorld(World world, Ray ray, int options) {
        super(ray);
        this.world = world;
        this.options = options;
        this.blockSrc = new BlockPos(this.src.toVec3d());
        int stepX = 1;
        int stepY = 1;
        int stepZ = 1;
        if (ray.direction.x < 0.0) {
            stepX = -1;
        }
        if (ray.direction.y < 0.0) {
            stepY = -1;
        }
        if (ray.direction.z < 0.0) {
            stepZ = -1;
        }
        this.step = new Vector(stepX, stepY, stepZ);
        if (this.hasOption(Options.LOG_BLOCK_PASSED)) {
            this.blockPassed = new HashMap();
        }
    }

    public RaytraceWorld(World world, Ray ray) {
        this(world, ray, 0);
    }

    public RaytraceWorld(World world, Point src, Vector v, int options) {
        this(world, new Ray(src, v), options);
    }

    public RaytraceWorld(World world, Point src, Vector v) {
        this(world, new Ray(src, v), 0);
    }

    public RaytraceWorld(World world, Point src, Point dest, int options) {
        this(world, new Ray(src, new Vector(src, dest)), options);
        this.dest = dest;
        this.blockDest = new BlockPos(dest.toVec3d());
    }

    public RaytraceWorld(World world, Point src, Point dest) {
        this(world, new Ray(src, new Vector(src, dest)), 0);
        this.dest = dest;
        this.blockDest = new BlockPos(dest.toVec3d());
    }

    @Override
    public void setLength(double length) {
        super.setLength(length);
        this.blockDest = new BlockPos(this.dest.toVec3d());
    }

    public boolean hasOption(int opt) {
        return (this.options & opt) != 0;
    }

    public RayTraceResult trace() {
        RayTraceResult mop = null;
        RayTraceResult firstHit = null;
        int count = 0;
        boolean ret = false;
        int currentX = this.blockSrc.func_177958_n();
        int currentY = this.blockSrc.func_177956_o();
        int currentZ = this.blockSrc.func_177952_p();
        while (!ret && count++ <= 200) {
            double tX = this.ray.intersectX(currentX + (this.ray.direction.x > 0.0 ? 1 : 0));
            double tY = this.ray.intersectY(currentY + (this.ray.direction.y > 0.0 ? 1 : 0));
            double tZ = this.ray.intersectZ(currentZ + (this.ray.direction.z > 0.0 ? 1 : 0));
            double min = this.getMin(tX, tY, tZ);
            if (count != 1 || !this.hasOption(Options.IGNORE_FIRST_BLOCK)) {
                mop = this.rayTraceBlock(new BlockPos(currentX, currentY, currentZ), this.ray.getPointAt(min));
            }
            if (firstHit == null) {
                firstHit = mop;
            }
            if (this.hasOption(Options.LOG_BLOCK_PASSED)) {
                this.blockPassed.put(new BlockPos(currentX, currentY, currentZ), mop);
            }
            if (this.dest != null && currentX == this.blockDest.func_177958_n() && currentY == this.blockDest.func_177956_o() && currentZ == this.blockDest.func_177952_p()) {
                ret = true;
            }
            if (!ret) {
                if (min == tX) {
                    currentX = (int)((double)currentX + this.step.x);
                }
                if (min == tY) {
                    currentY = (int)((double)currentY + this.step.y);
                }
                if (min == tZ) {
                    currentZ = (int)((double)currentZ + this.step.z);
                }
            }
            if (this.dest == null || !this.dest.equals(this.ray.getPointAt(min))) continue;
            ret = true;
        }
        if (firstHit == null && this.dest != null) {
            firstHit = new RayTraceResult(RayTraceResult.Type.MISS, this.dest.toVec3d(), null, new BlockPos(currentX, currentY, currentZ));
        }
        firstHit = ChunkCollision.get().getRayTraceResult(this.world, (Pair<Point, Point>)Pair.of((Object)this.src, (Object)this.dest), firstHit, this.hasOption(Options.HIT_LIQUIDS), this.hasOption(Options.CHECK_COLLISION), true);
        if (!ret) {
            MalisisCore.message("Trace fail : 200 blocks passed (" + currentX + "," + currentY + "," + currentZ + ")");
        }
        return firstHit;
    }

    public double getMin(double x, double y, double z) {
        double ret = Double.NaN;
        if (!Double.isNaN(x)) {
            ret = x;
        }
        if (!Double.isNaN(y)) {
            ret = !Double.isNaN(ret) ? Math.min(ret, y) : y;
        }
        if (!Double.isNaN(z)) {
            ret = !Double.isNaN(ret) ? Math.min(ret, z) : z;
        }
        return ret;
    }

    public RayTraceResult rayTraceBlock(BlockPos pos, Point exit) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (this.hasOption(Options.CHECK_COLLISION) && state.func_185900_c((IBlockAccess)this.world, pos) == null) {
            return null;
        }
        if (!block.func_176209_a(state, this.hasOption(Options.HIT_LIQUIDS))) {
            return null;
        }
        return new RaytraceBlock(this.world, this.src, exit, pos).trace();
    }

    public static class Options {
        public static int HIT_LIQUIDS = 1;
        public static int PASS_THROUGH = 2;
        public static int IGNORE_FIRST_BLOCK = 4;
        public static int LOG_BLOCK_PASSED = 8;
        public static int CHECK_COLLISION = 32;
    }
}

