/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.proxy;

import cofh.CoFHCore;
import cofh.api.item.IToolBow;
import cofh.api.item.IToolQuiver;
import cofh.core.enchantment.EnchantmentSmashing;
import cofh.core.enchantment.EnchantmentSmelting;
import cofh.core.enchantment.EnchantmentSoulbound;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.item.tool.ItemShieldCore;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.NBTHelper;
import java.util.ListIterator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleArrowLooseEvent(ArrowLooseEvent event) {
        boolean flag;
        if (event.getBow().func_77973_b() != Items.field_151031_f && !(event.getBow().func_77973_b() instanceof IToolBow)) {
            return;
        }
        ItemStack bowStack = event.getBow();
        IToolBow bow = null;
        EntityPlayer player = event.getEntityPlayer();
        ItemStack arrowStack = this.findAmmo(player);
        World world = event.getWorld();
        boolean customArrow = false;
        if (bowStack.func_77973_b() instanceof IToolBow) {
            bow = (IToolBow)bowStack.func_77973_b();
        }
        boolean bl = flag = player.field_71075_bZ.field_75098_d || arrowStack.func_77973_b() instanceof ItemArrow && ((ItemArrow)arrowStack.func_77973_b()).isInfinite(arrowStack, bowStack, player);
        if (arrowStack.func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bowStack) > 0) {
            flag = true;
        }
        if (!arrowStack.func_190926_b() || flag) {
            if (arrowStack.func_190926_b()) {
                arrowStack = new ItemStack(Items.field_151032_g);
            }
            float f = ItemBow.func_185059_b((int)event.getCharge());
            float speedMod = 1.0f;
            if (bow != null) {
                speedMod += bow.getArrowSpeedMultiplier(bowStack);
            }
            if ((double)f >= 0.1) {
                if (!world.field_72995_K) {
                    int encMultishot = MathHelper.clamp(EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.multishot, (ItemStack)bowStack), 0, CoreEnchantments.multishot.func_77325_b() * 2);
                    int encPunch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bowStack);
                    int encPower = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bowStack);
                    int encFlame = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bowStack);
                    if (bow != null) {
                        bow.onBowFired(player, bowStack);
                        customArrow = this.isQuiver(arrowStack) && !((IToolQuiver)arrowStack.func_77973_b()).allowCustomArrowOverride(arrowStack) ? false : bow.hasCustomArrow(bowStack);
                    }
                    for (int shot = 0; shot <= encMultishot; ++shot) {
                        EntityArrow arrow = this.createArrow(world, arrowStack, bowStack, customArrow, player);
                        arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f * speedMod, 1.0f + (1.5f - f) * (float)(shot * 2));
                        if (bow != null) {
                            arrow.func_70239_b(arrow.func_70242_d() * (double)(1.0f + bow.getArrowDamageMultiplier(bowStack)));
                        }
                        if (f >= 1.0f) {
                            arrow.func_70243_d(true);
                        }
                        if (encPower > 0) {
                            arrow.func_70239_b(arrow.func_70242_d() + (double)encPower * 0.5 + 0.5);
                        }
                        if (encPunch > 0) {
                            arrow.func_70240_a(encPunch);
                        }
                        if (encFlame > 0) {
                            arrow.func_70015_d(100);
                        }
                        if (flag || shot > 0) {
                            arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_72838_d((Entity)arrow);
                    }
                    bowStack.func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!flag && !player.field_71075_bZ.field_75098_d) {
                    if (this.isQuiver(arrowStack)) {
                        ((IToolQuiver)arrowStack.func_77973_b()).onArrowFired(arrowStack, (EntityLivingBase)player);
                    } else {
                        arrowStack.func_190918_g(1);
                        if (arrowStack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(arrowStack);
                        }
                    }
                }
                player.func_71029_a(StatList.func_188057_b((Item)bowStack.func_77973_b()));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleArrowNockEvent(ArrowNockEvent event) {
        if (event.getBow().func_77973_b() != Items.field_151031_f && !(event.getBow().func_77973_b() instanceof IToolBow)) {
            return;
        }
        ItemStack stack = event.getBow();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack arrowStack = this.findAmmo(player);
        if (arrowStack.func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0) {
            arrowStack = new ItemStack(Items.field_151032_g);
        }
        if (!arrowStack.func_190926_b()) {
            player.func_184598_c(event.getHand());
            event.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)stack));
        } else if (!player.field_71075_bZ.field_75098_d) {
            event.setAction(new ActionResult(EnumActionResult.FAIL, (Object)stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handleLivingAttackEvent(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        DamageSource source = event.getSource();
        if (source instanceof EntityDamageSourceIndirect || source.func_76363_c() || source.func_76352_a()) {
            return;
        }
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ItemStack stack = player.func_184607_cu();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemShieldCore) {
            ((ItemShieldCore)stack.func_77973_b()).onHit(stack, player, source.func_76346_g());
        }
    }

    @SubscribeEvent
    public void handleLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof EntityPlayer) {
            int encLeech = this.getHeldEnchantmentLevel((EntityLivingBase)((EntityPlayer)attacker), CoreEnchantments.leech);
            int encInsight = this.getHeldEnchantmentLevel((EntityLivingBase)((EntityPlayer)attacker), CoreEnchantments.insight);
            if (encLeech > 0) {
                ((EntityPlayer)attacker).func_70691_i((float)encLeech);
            }
            if (encInsight > 0) {
                entity.field_70170_p.func_72838_d((Entity)new EntityXPOrb(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v, encInsight + entity.field_70170_p.field_73012_v.nextInt(1 + encInsight * 3)));
            }
        }
        if (!CoreProps.enableLivingEntityDeathMessages || entity.field_70170_p.field_72995_K || !(entity instanceof EntityLiving) || !event.getEntityLiving().func_145818_k_()) {
            return;
        }
        PlayerList playerList = entity.field_70170_p.func_73046_m().func_184103_al();
        ITextComponent deathMessage = event.getEntityLiving().func_110142_aN().func_151521_b();
        if (playerList == null) {
            CoFHCore.LOG.error("Null Player List! That's not good.", (Object)event);
        }
        if (deathMessage == null) {
            CoFHCore.LOG.error("Null Death Message! Please report to the mod responsible.", event.getSource().getClass());
        }
        entity.field_70170_p.func_73046_m().func_184103_al().func_148539_a(event.getEntityLiving().func_110142_aN().func_151521_b());
    }

    @SubscribeEvent
    public void handleLivingHurtEvent(LivingHurtEvent event) {
        int encVorpal;
        Entity entity = event.getEntity();
        if (entity instanceof IProjectile) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = event.getSource().func_76346_g();
        if (!(attacker instanceof EntityLivingBase)) {
            return;
        }
        if (source.field_76373_n.equals("arrow")) {
            int encMultishot = MathHelper.clamp(this.getHeldEnchantmentLevel((EntityLivingBase)attacker, CoreEnchantments.multishot), 0, CoreEnchantments.multishot.func_77325_b() * 2);
            if (encMultishot > 0) {
                entity.field_70172_ad = 0;
            }
        } else if (source.field_76373_n.equals("player") && (encVorpal = this.getHeldEnchantmentLevel((EntityLivingBase)attacker, CoreEnchantments.vorpal)) > 0 && entity.field_70170_p.field_73012_v.nextInt(100) < 5 * encVorpal) {
            event.setAmount(event.getAmount() * 10.0f);
            attacker.field_70170_p.func_184133_a(null, attacker.func_180425_c(), SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < encVorpal * 2; ++i) {
                ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.CRIT, entity.field_70165_t + entity.field_70170_p.field_73012_v.nextDouble(), entity.field_70163_u + 1.5, entity.field_70161_v + entity.field_70170_p.field_73012_v.nextDouble(), 1, 0.0, 0.0, 0.0, 0.0, new int[]{0});
                ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t + entity.field_70170_p.field_73012_v.nextDouble(), entity.field_70163_u + 1.5, entity.field_70161_v + entity.field_70170_p.field_73012_v.nextDouble(), 1, 0.0, 0.0, 0.0, 0.0, new int[]{0});
            }
        }
    }

    @SubscribeEvent
    public void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        int encInsight;
        EntityPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (event.getExpToDrop() > 0 && (encInsight = MathHelper.clamp(EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.insight, (ItemStack)player.func_184614_ca()), 0, CoreEnchantments.insight.func_77325_b() * 2)) > 0) {
            event.setExpToDrop(event.getExpToDrop() + encInsight + player.field_70170_p.field_73012_v.nextInt(1 + encInsight * 3));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void handleHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (player == null || event.isSilkTouching()) {
            return;
        }
        ItemStack tool = ItemHelper.getMainhandStack(player);
        int encSmashing = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.smashing, (ItemStack)tool);
        int encSmelting = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.smelting, (ItemStack)tool);
        try {
            event.getDrops().replaceAll(stack -> {
                ItemStack smelted;
                ItemStack smashed;
                if (stack.func_190926_b()) {
                    return stack;
                }
                ItemStack result = stack;
                if (encSmashing > 0 && !(smashed = EnchantmentSmashing.getItemStack(result)).func_190926_b()) {
                    result = smashed;
                }
                if (encSmelting > 0 && !(smelted = EnchantmentSmelting.getItemStack(result)).func_190926_b()) {
                    result = smelted;
                }
                return result;
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=false)
    public void handleLivingDropsEvent(LivingDropsEvent event) {
        Entity source = event.getSource().func_76346_g();
        if (!(source instanceof EntityPlayer) || !event.isRecentlyHit()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)source;
        int encVorpal = MathHelper.clamp(EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.vorpal, (ItemStack)player.func_184614_ca()), 0, CoreEnchantments.vorpal.func_77325_b() * 2);
        if (encVorpal > 0) {
            Entity entity = event.getEntity();
            ItemStack itemSkull = ItemStack.field_190927_a;
            if (entity.field_70170_p.field_73012_v.nextInt(100) < 20 * encVorpal) {
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP target = (EntityPlayerMP)event.getEntity();
                    itemSkull = new ItemStack(Items.field_151144_bL, 1, 3);
                    NBTHelper.setString(itemSkull, "SkullOwner", target.func_70005_c_());
                } else if (entity instanceof EntitySkeleton) {
                    itemSkull = new ItemStack(Items.field_151144_bL, 1, 0);
                } else if (entity instanceof EntityWitherSkeleton) {
                    itemSkull = new ItemStack(Items.field_151144_bL, 1, 1);
                } else if (entity instanceof EntityZombie) {
                    itemSkull = new ItemStack(Items.field_151144_bL, 1, 2);
                } else if (entity instanceof EntityCreeper) {
                    itemSkull = new ItemStack(Items.field_151144_bL, 1, 4);
                }
            }
            if (itemSkull.func_190926_b()) {
                return;
            }
            EntityItem drop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemSkull);
            drop.func_174867_a(10);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handlePlayerDropsEvent(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        ListIterator iter = event.getDrops().listIterator();
        while (iter.hasNext()) {
            EntityItem drop = (EntityItem)iter.next();
            ItemStack stack = drop.func_92059_d();
            if (!this.isSoulbound(stack) || !EventHandler.addToPlayerInventory(player, stack)) continue;
            iter.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        int encSoulbound;
        ItemStack stack;
        int i;
        if (!event.isWasDeath()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EntityPlayer oldPlayer = event.getOriginal();
        if (player instanceof FakePlayer) {
            return;
        }
        if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        for (i = 0; i < oldPlayer.field_71071_by.field_70460_b.size(); ++i) {
            stack = (ItemStack)oldPlayer.field_71071_by.field_70460_b.get(i);
            encSoulbound = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.soulbound, (ItemStack)stack);
            if (encSoulbound <= 0) continue;
            if (EnchantmentSoulbound.permanent) {
                if (encSoulbound > 1) {
                    ItemHelper.removeEnchantment(stack, CoreEnchantments.soulbound);
                    ItemHelper.addEnchantment(stack, CoreEnchantments.soulbound, 1);
                }
            } else if (MathHelper.RANDOM.nextInt(1 + encSoulbound) == 0) {
                ItemHelper.removeEnchantment(stack, CoreEnchantments.soulbound);
                if (encSoulbound > 1) {
                    ItemHelper.addEnchantment(stack, CoreEnchantments.soulbound, encSoulbound - 1);
                }
            }
            if (!EventHandler.addToPlayerInventory(player, stack)) continue;
            oldPlayer.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < oldPlayer.field_71071_by.field_70462_a.size(); ++i) {
            stack = (ItemStack)oldPlayer.field_71071_by.field_70462_a.get(i);
            encSoulbound = MathHelper.clamp(EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.soulbound, (ItemStack)stack), 0, CoreEnchantments.soulbound.func_77325_b() * 2);
            if (encSoulbound <= 0) continue;
            if (MathHelper.RANDOM.nextInt(1 + encSoulbound) == 0) {
                ItemHelper.removeEnchantment(stack, CoreEnchantments.soulbound);
                if (encSoulbound > 1) {
                    ItemHelper.addEnchantment(stack, CoreEnchantments.soulbound, encSoulbound - 1);
                }
            }
            if (!EventHandler.addToPlayerInventory(player, stack)) continue;
            oldPlayer.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public boolean isQuiver(ItemStack stack) {
        return stack.func_77973_b() instanceof IToolQuiver;
    }

    public boolean isSoulbound(ItemStack stack) {
        return this.getEnchantmentLevel(stack, CoreEnchantments.soulbound) > 0;
    }

    public static boolean addToPlayerInventory(EntityPlayer player, ItemStack stack) {
        if (stack.func_190926_b() || player == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor arm = (ItemArmor)stack.func_77973_b();
            int index = arm.field_77881_a.func_188454_b();
            if (((ItemStack)player.field_71071_by.field_70460_b.get(index)).func_190926_b()) {
                player.field_71071_by.field_70460_b.set(index, (Object)stack);
                return true;
            }
        }
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (!((ItemStack)inv.field_70462_a.get(i)).func_190926_b()) continue;
            inv.field_70462_a.set(i, (Object)stack.func_77946_l());
            return true;
        }
        return false;
    }

    public EntityArrow createArrow(World world, ItemStack arrowStack, ItemStack bowStack, boolean customArrow, EntityPlayer player) {
        if (customArrow) {
            return ((IToolBow)bowStack.func_77973_b()).createEntityArrow(world, bowStack, (EntityLivingBase)player);
        }
        if (this.isArrow(arrowStack)) {
            return ((ItemArrow)arrowStack.func_77973_b()).func_185052_a(world, arrowStack, (EntityLivingBase)player);
        }
        if (this.isQuiver(arrowStack)) {
            return ((IToolQuiver)arrowStack.func_77973_b()).createEntityArrow(world, arrowStack, (EntityLivingBase)player);
        }
        return ((ItemArrow)Items.field_151032_g).func_185052_a(world, arrowStack, (EntityLivingBase)player);
    }

    public ItemStack findAmmo(EntityPlayer player) {
        ItemStack offHand = player.func_184592_cb();
        ItemStack mainHand = player.func_184614_ca();
        if (this.isQuiver(offHand) && !((IToolQuiver)offHand.func_77973_b()).isEmpty(offHand, (EntityLivingBase)player) || this.isArrow(offHand)) {
            return offHand;
        }
        if (this.isQuiver(mainHand) && !((IToolQuiver)mainHand.func_77973_b()).isEmpty(mainHand, (EntityLivingBase)player) || this.isArrow(mainHand)) {
            return mainHand;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if ((!this.isQuiver(stack) || ((IToolQuiver)stack.func_77973_b()).isEmpty(stack, (EntityLivingBase)player)) && !this.isArrow(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public int getHeldEnchantmentLevel(EntityLivingBase player, Enchantment enc) {
        return Math.max(EnchantmentHelper.func_77506_a((Enchantment)enc, (ItemStack)player.func_184614_ca()), EnchantmentHelper.func_77506_a((Enchantment)enc, (ItemStack)player.func_184592_cb()));
    }

    public int getEnchantmentLevel(ItemStack item, Enchantment enc) {
        return EnchantmentHelper.func_77506_a((Enchantment)enc, (ItemStack)item);
    }
}

