/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.monster.Monster;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagMobInteractListener {
    @Listener
    public void onInteract(InteractEntityEvent event, @First Player player) {
        if (!(event.getTargetEntity() instanceof Player)) {
            this.handleEvent(event, event.getTargetEntity(), player);
        }
    }

    private void handleEvent(InteractEntityEvent event, Entity entity, Player player) {
        EntityType type = entity.getType();
        if (!FlagUtils.isBlockEntity(type) && !FlagUtils.isVehicle(type) && entity instanceof Living) {
            String name = type.getId().toLowerCase();
            Region region = RegionUtils.getRegion((Location<World>)entity.getLocation());
            if (region != null) {
                boolean cancel;
                boolean relatedAllFlag;
                boolean bl = relatedAllFlag = !region.getMobInteract("all");
                if (entity instanceof Monster) {
                    boolean bl2 = relatedAllFlag = relatedAllFlag || !region.getMobInteract("allhostile");
                }
                if (entity instanceof Creature || entity instanceof Animal) {
                    relatedAllFlag = relatedAllFlag || !region.getMobInteract("allpassive");
                }
                boolean bl3 = cancel = relatedAllFlag || !region.getMobInteract(name) && !PermissionUtils.hasPermission(player, RegionPermission.REGION);
                if (cancel) {
                    event.setCancelled(true);
                    MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                }
            }
        }
    }
}

