/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.common.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.capabilities.energy.adapter.ElectricAdapter;
import net.machinemuse.numina.common.config.NuminaServerSettings;
import net.machinemuse.numina.common.config.NuminaSettings;
import net.minecraft.item.ItemStack;

public enum NuminaConfig {
    INSTANCE;

    private static NuminaServerSettings serverSettings;

    public static boolean useSounds() {
        return NuminaSettings.useSounds;
    }

    public static boolean isDebugging() {
        return NuminaSettings.isDebugging;
    }

    public static boolean useFOVFix() {
        return NuminaSettings.useFOVFix;
    }

    public static boolean fovFixDefaultState() {
        return NuminaSettings.fovFixDefaultState;
    }

    public static double getMekRatio() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().mekRatio : NuminaSettings.mekRatio;
    }

    public static double getIC2Ratio() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().ic2Ratio : NuminaSettings.ic2Ratio;
    }

    public static double getRSRatio() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().rsRatio : NuminaSettings.rsRatio;
    }

    public static double getAE2Ratio() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().ae2Ratio : NuminaSettings.ae2Ratio;
    }

    public static int getTier1MaxRF() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().maxTier1 : NuminaSettings.maxTier1;
    }

    public static int getTier2MaxRF() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().maxTier2 : NuminaSettings.maxTier2;
    }

    public static int getTier3MaxRF() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().maxTier3 : NuminaSettings.maxTier3;
    }

    public static int getTier4MaxRF() {
        return NuminaConfig.getServerSettings() != null ? NuminaConfig.getServerSettings().maxTier4 : NuminaSettings.maxTier4;
    }

    public static int getTierForItem(@Nonnull ItemStack itemStack) {
        ElectricAdapter adapter = ElectricAdapter.wrap(itemStack);
        if (adapter != null) {
            int maxEnergy = adapter.getMaxEnergyStored();
            if (maxEnergy <= NuminaConfig.getTier1MaxRF()) {
                return 1;
            }
            if (maxEnergy <= NuminaConfig.getTier2MaxRF()) {
                return 2;
            }
            if (maxEnergy <= NuminaConfig.getTier3MaxRF()) {
                return 3;
            }
            if (maxEnergy <= NuminaConfig.getTier4MaxRF()) {
                return 4;
            }
            return 5;
        }
        return 0;
    }

    @Nullable
    public static final NuminaServerSettings getServerSettings() {
        return serverSettings;
    }

    public static void setServerSettings(@Nullable NuminaServerSettings serverSettings) {
        NuminaConfig.serverSettings = serverSettings;
    }
}

