/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.gui.clickable;

import java.util.List;
import net.machinemuse.numina.gui.IClickable;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.numina.utils.render.MuseRenderer;

public class ClickableLabel
implements IClickable {
    protected String label;
    protected MusePoint2D position;
    protected int mode;

    public ClickableLabel(String label, MusePoint2D position) {
        this.label = label;
        this.position = position;
        this.mode = 1;
    }

    public ClickableLabel(String label, MusePoint2D position, int mode) {
        this.label = label;
        this.position = position;
        this.mode = mode;
    }

    public ClickableLabel setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void draw() {
        if (this.mode == 0) {
            MuseRenderer.drawLeftAlignedStringString(this.label, this.position.getX(), this.position.getY() - 4.0);
        }
        if (this.mode == 1) {
            MuseRenderer.drawCenteredString(this.label, this.position.getX(), this.position.getY() - 4.0);
        }
        if (this.mode == 2) {
            MuseRenderer.drawRightAlignedString(this.label, this.position.getX(), this.position.getY() - 4.0);
        }
    }

    @Override
    public boolean hitBox(double x, double y) {
        if (this.label == null || this.label.isEmpty()) {
            return false;
        }
        MusePoint2D radius = new MusePoint2D(MuseRenderer.getStringWidth(this.label) / 2.0 + 2.0, 6.0);
        boolean hitx = Math.abs(this.position.getX() - x) < radius.getX();
        boolean hity = Math.abs(this.position.getY() - y) < radius.getY();
        return hitx && hity;
    }

    @Override
    public List<String> getToolTip() {
        return null;
    }

    @Override
    public void move(double x, double y) {
        this.position.setX(x);
        this.position.setY(y);
    }

    @Override
    public MusePoint2D getPosition() {
        return this.position;
    }
}

