/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.gui.clickable;

import net.machinemuse.numina.gui.clickable.Clickable;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.numina.utils.math.geometry.DrawableMuseRect;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.numina.utils.render.MuseRenderer;
import net.minecraft.client.resources.I18n;

public class ClickableSlider
extends Clickable {
    final int cornersize = 3;
    private double valueInternal = 0.0;
    MusePoint2D pos;
    double width;
    private String id;
    private String label;
    DrawableMuseRect insideRect;
    DrawableMuseRect outsideRect;

    public ClickableSlider(MusePoint2D pos, double width, String id, String label) {
        this.pos = pos;
        this.width = width;
        this.id = id;
        this.position = pos;
        this.insideRect = new DrawableMuseRect(this.position.getX() - width / 2.0 - 3.0, this.position.getY() + 8.0, 0.0, this.position.getY() + 16.0, Colour.LIGHTBLUE, Colour.ORANGE);
        this.outsideRect = new DrawableMuseRect(this.position.getX() - width / 2.0 - 3.0, this.position.getY() + 8.0, this.position.getX() + width / 2.0 + 3.0, this.position.getY() + 16.0, Colour.LIGHTBLUE, Colour.DARKBLUE);
        this.label = label;
    }

    public String id() {
        return this.id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void draw() {
        MuseRenderer.drawCenteredString(I18n.func_135052_a((String)this.label, (Object[])new Object[0]), this.position.getX(), this.position.getY());
        this.insideRect.setRight(this.position.getX() + this.width * (this.getValue() - 0.5) + 3.0);
        this.outsideRect.draw();
        this.insideRect.draw();
    }

    @Override
    public boolean hitBox(double x, double y) {
        return Math.abs(this.position.getX() - x) < this.width / 2.0 && Math.abs(this.position.getY() + 12.0 - y) < 4.0;
    }

    public double getValue() {
        return this.valueInternal;
    }

    public void setValue(double v) {
        this.valueInternal = v;
    }

    public void setValueByX(double x) {
        this.valueInternal = MuseMathUtils.clampDouble((x - this.pos.getX()) / this.width + 0.5, 0.0, 1.0);
    }
}

