/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.gui.scrollable;

import java.util.List;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.gui.frame.IGuiFrame;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.numina.utils.math.geometry.DrawableMuseRect;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScrollableFrame
implements IGuiFrame {
    protected final int buttonsize = 5;
    protected int totalsize;
    protected int currentscrollpixels;
    protected int lastdWheel = Mouse.getDWheel();
    protected boolean visibile = true;
    protected boolean enabled = true;
    protected DrawableMuseRect border;

    public ScrollableFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        this.border = new DrawableMuseRect(topleft, bottomright, borderColour, insideColour);
    }

    protected double getScrollAmount() {
        return 8.0;
    }

    @Override
    public void update(double x, double y) {
        if (this.border.containsPoint(x, y)) {
            int dscroll = (this.lastdWheel - Mouse.getDWheel()) / 15;
            this.lastdWheel = Mouse.getDWheel();
            if (Mouse.isButtonDown((int)0)) {
                if (y - this.border.top() < 5.0 && this.currentscrollpixels > 0) {
                    dscroll = (int)((double)dscroll - this.getScrollAmount());
                } else if (this.border.bottom() - y < 5.0) {
                    dscroll = (int)((double)dscroll + this.getScrollAmount());
                }
            }
            this.currentscrollpixels = (int)MuseMathUtils.clampDouble(this.currentscrollpixels + dscroll, 0.0, this.getMaxScrollPixels());
        }
    }

    public void preDraw() {
        this.border.draw();
        RenderState.glowOn();
        RenderState.texturelessOn();
        GL11.glBegin((int)4);
        Colour.LIGHTBLUE.doGL();
        if ((double)this.currentscrollpixels + this.border.height() < (double)this.totalsize) {
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0), (double)this.border.bottom(), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 + 2.0), (double)(this.border.bottom() - 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 - 2.0), (double)(this.border.bottom() - 4.0), (double)1.0);
        }
        if (this.currentscrollpixels > 0) {
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0), (double)this.border.top(), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 - 2.0), (double)(this.border.top() + 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.border.left() + this.border.width() / 2.0 + 2.0), (double)(this.border.top() + 4.0), (double)1.0);
        }
        Colour.WHITE.doGL();
        GL11.glEnd();
        RenderState.texturelessOff();
        RenderState.scissorsOn(this.border.left() + 4.0, this.border.top() + 4.0, this.border.width() - 8.0, this.border.height() - 8.0);
    }

    public void postDraw() {
        RenderState.scissorsOff();
        RenderState.glowOff();
    }

    @Override
    public void draw() {
        this.preDraw();
        this.postDraw();
    }

    public void frameOff() {
        this.disable();
        this.hide();
    }

    public void frameOn() {
        this.enable();
        this.show();
    }

    public void hide() {
        this.visibile = false;
    }

    public void show() {
        this.visibile = true;
    }

    public boolean isVisibile() {
        return this.visibile;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
    }

    public int getMaxScrollPixels() {
        return (int)Math.max((double)this.totalsize - this.border.height(), 0.0);
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

