/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.item;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.module.IEnchantmentModule;
import net.machinemuse.numina.module.IModuleManager;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.network.NuminaPackets;
import net.machinemuse.numina.network.packets.MusePacketModeChangeRequest;
import net.machinemuse.numina.utils.nbt.MuseNBTUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IModeChangingItem
extends IModularItem {
    @SideOnly(value=Side.CLIENT)
    @Nullable
    default public TextureAtlasSprite getModeIcon(String mode, @Nonnull ItemStack stack, EntityPlayer player) {
        IModuleManager moduleManager;
        IPowerModule module;
        if (stack.func_77973_b() instanceof IModularItem && (module = (moduleManager = ((IModularItem)stack.func_77973_b()).getModuleManager()).getModule(mode)) != null) {
            return module.getIcon(stack);
        }
        return null;
    }

    default public List<String> getValidModes(@Nonnull ItemStack stack) {
        LinkedList<String> modes = new LinkedList<String>();
        if (!(stack.func_77973_b() instanceof IModeChangingItem)) {
            return modes;
        }
        IModuleManager moduleManager = ((IModularItem)stack.func_77973_b()).getModuleManager();
        for (Object module : moduleManager.getModulesOfType(IRightClickModule.class)) {
            if (!moduleManager.isValidForItem(stack, (IPowerModule)module) || !moduleManager.itemHasModule(stack, ((IPowerModule)module).getDataName())) continue;
            modes.add(((IPowerModule)module).getDataName());
        }
        return modes;
    }

    default public String getActiveMode(@Nonnull ItemStack stack) {
        String modeFromNBT = MuseNBTUtils.getMuseItemTag(stack).func_74779_i("mode");
        if (modeFromNBT.isEmpty()) {
            List<String> validModes = this.getValidModes(stack);
            return validModes != null && validModes.size() > 0 ? validModes.get(0) : "";
        }
        return modeFromNBT;
    }

    default public void setActiveMode(@Nonnull ItemStack stack, String newMode) {
        String activeMode = this.getActiveMode(stack);
        IPowerModule oldModule = this.getModuleManager().getModule(activeMode);
        if (oldModule instanceof IEnchantmentModule) {
            ((IEnchantmentModule)oldModule).removeEnchantment(stack);
        }
        MuseNBTUtils.getMuseItemTag(stack).func_74778_a("mode", newMode);
        IPowerModule module = this.getModuleManager().getModule(newMode);
        if (module instanceof IEnchantmentModule) {
            ((IEnchantmentModule)module).addEnchantment(stack);
        }
    }

    default public void cycleMode(ItemStack stack, EntityPlayer player, int dMode) {
        List<String> modes = this.getValidModes(stack);
        if (modes.size() > 0) {
            int newindex = this.clampMode(modes.indexOf(this.getActiveMode(stack)) + dMode, modes.size());
            String newmode = modes.get(newindex);
            this.setActiveMode(stack, newmode);
            NuminaPackets.sendToServer(new MusePacketModeChangeRequest(player, newmode, player.field_71071_by.field_70461_c));
        }
    }

    default public String nextMode(ItemStack stack, EntityPlayer player) {
        List<String> modes = this.getValidModes(stack);
        if (modes.size() > 0) {
            int newindex = this.clampMode(modes.indexOf(this.getActiveMode(stack)) + 1, modes.size());
            return modes.get(newindex);
        }
        return "";
    }

    default public String prevMode(ItemStack stack, EntityPlayer player) {
        List<String> modes = this.getValidModes(stack);
        if (modes.size() > 0) {
            int newindex = this.clampMode(modes.indexOf(this.getActiveMode(stack)) - 1, modes.size());
            return modes.get(newindex);
        }
        return "";
    }

    default public int clampMode(int selection, int modesSize) {
        return selection > 0 ? selection % modesSize : (selection + modesSize * -selection) % modesSize;
    }
}

