/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.utils.math.geometry;

import java.nio.DoubleBuffer;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.geometry.GradientAndArcCalculator;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DrawableMuseCircle {
    public static final double detail = 4.0;
    protected static DoubleBuffer points;
    protected final DoubleBuffer colour;

    public DrawableMuseCircle(Colour c1, Colour c2) {
        if (points == null) {
            DoubleBuffer arcPoints = GradientAndArcCalculator.getArcPoints(0.0, 6.283285307179586, 4.0, 0.0, 0.0, 0.0);
            points = BufferUtils.createDoubleBuffer((int)(arcPoints.limit() + 6));
            points.put(new double[]{0.0, 0.0, 0.0});
            points.put(arcPoints);
            arcPoints.rewind();
            points.put(arcPoints.get());
            points.put(arcPoints.get());
            points.put(arcPoints.get());
            points.flip();
        }
        DoubleBuffer colourPoints = GradientAndArcCalculator.getColourGradient(c1, c1, points.limit() / 3);
        this.colour = BufferUtils.createDoubleBuffer((int)(colourPoints.limit() + 4));
        this.colour.put(c2.asArray());
        this.colour.put(colourPoints);
        this.colour.flip();
    }

    public void draw(double radius, double x, double y) {
        points.rewind();
        this.colour.rewind();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)(radius / 4.0), (double)(radius / 4.0), (double)1.0);
        RenderState.on2D();
        GL11.glEnable((int)2929);
        RenderState.arraysOnColor();
        RenderState.texturelessOn();
        RenderState.blendingOn();
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.colour);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)points);
        GL11.glDrawArrays((int)6, (int)0, (int)(points.limit() / 3));
        RenderState.blendingOff();
        RenderState.texturelessOff();
        RenderState.arraysOff();
        RenderState.off2D();
        GL11.glPopMatrix();
    }
}

