/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.utils.math.geometry;

import java.nio.DoubleBuffer;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.geometry.GradientAndArcCalculator;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.numina.utils.math.geometry.MuseRect;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DrawableMuseRect
extends MuseRect {
    MuseRect lastRect;
    Colour insideColour;
    Colour outsideColour;
    DoubleBuffer vertices;
    DoubleBuffer coloursInside;
    DoubleBuffer coloursOutside;

    public DrawableMuseRect(double left, double top, double right, double bottom, boolean growFromMiddle, Colour insideColour, Colour outsideColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.insideColour = insideColour;
        this.outsideColour = outsideColour;
        if (growFromMiddle) {
            this.lastRect = new MuseRect(left, top, right, bottom);
        }
    }

    public DrawableMuseRect(double left, double top, double right, double bottom, Colour insideColour, Colour outsideColour) {
        super(left, top, right, bottom, false);
        this.insideColour = insideColour;
        this.outsideColour = outsideColour;
    }

    public DrawableMuseRect(MusePoint2D ul, MusePoint2D br, Colour insideColour, Colour outsideColour) {
        super(ul, br);
        this.insideColour = insideColour;
        this.outsideColour = outsideColour;
    }

    public DrawableMuseRect(MuseRect ref, Colour insideColour, Colour outsideColour) {
        super(ref.left(), ref.top(), ref.right(), ref.bottom());
        this.insideColour = insideColour;
        this.outsideColour = outsideColour;
    }

    @Override
    public DrawableMuseRect copyOf() {
        return new DrawableMuseRect(super.left(), super.top(), super.right(), super.bottom(), this.lastRect != null, this.insideColour, this.outsideColour);
    }

    @Override
    public DrawableMuseRect setLeft(double value) {
        super.setLeft(value);
        return this;
    }

    @Override
    public DrawableMuseRect setRight(double value) {
        super.setRight(value);
        return this;
    }

    @Override
    public DrawableMuseRect setTop(double value) {
        super.setTop(value);
        return this;
    }

    @Override
    public DrawableMuseRect setBottom(double value) {
        super.setBottom(value);
        return this;
    }

    @Override
    public DrawableMuseRect setWidth(double value) {
        super.setWidth(value);
        return this;
    }

    @Override
    public DrawableMuseRect setHeight(double value) {
        super.setHeight(value);
        return this;
    }

    public void draw() {
        if (this.vertices == null || this.coloursInside == null || this.coloursOutside == null || this.lastRect != null && !this.lastRect.equals(this)) {
            this.lastRect = new MuseRect(this.left(), this.top(), this.right(), this.bottom());
            double cornerradius = 3.0;
            double zLevel = 1.0;
            DoubleBuffer corner = GradientAndArcCalculator.getArcPoints(Math.PI, 4.71238898038469, cornerradius, this.left() + cornerradius, this.top() + cornerradius, zLevel);
            this.vertices = BufferUtils.createDoubleBuffer((int)(corner.limit() * 4));
            this.vertices.put(corner);
            corner = GradientAndArcCalculator.getArcPoints(4.71238898038469, Math.PI * 2, cornerradius, this.left() + cornerradius, this.bottom() - cornerradius, zLevel);
            this.vertices.put(corner);
            corner = GradientAndArcCalculator.getArcPoints(0.0, 1.5707963267948966, cornerradius, this.right() - cornerradius, this.bottom() - cornerradius, zLevel);
            this.vertices.put(corner);
            corner = GradientAndArcCalculator.getArcPoints(1.5707963267948966, Math.PI, cornerradius, this.right() - cornerradius, this.top() + cornerradius, zLevel);
            this.vertices.put(corner);
            this.vertices.flip();
            this.coloursInside = GradientAndArcCalculator.getColourGradient(this.outsideColour, this.outsideColour, this.vertices.limit() * 4 / 3 + 8);
            this.coloursOutside = GradientAndArcCalculator.getColourGradient(this.insideColour, this.insideColour, this.vertices.limit() * 4 / 3 + 8);
        }
        RenderState.blendingOn();
        RenderState.on2D();
        RenderState.texturelessOn();
        RenderState.arraysOnColor();
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.coloursInside);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)this.vertices);
        GL11.glDrawArrays((int)6, (int)0, (int)(this.vertices.limit() / 3));
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.coloursOutside);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)this.vertices);
        GL11.glDrawArrays((int)2, (int)0, (int)(this.vertices.limit() / 3));
        RenderState.texturelessOff();
        RenderState.off2D();
        RenderState.blendingOff();
        RenderState.arraysOff();
    }

    public DrawableMuseRect setInsideColour(Colour insideColour) {
        this.insideColour = insideColour;
        return this;
    }

    public DrawableMuseRect setOutsideColour(Colour outsideColour) {
        this.outsideColour = outsideColour;
        return this;
    }
}

