/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.event;

import java.util.ArrayList;
import java.util.Objects;
import net.machinemuse.numina.control.PlayerInputMap;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.heat.MuseHeatUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.numina.utils.render.MuseRenderer;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.gui.hud.EnergyMeter;
import net.machinemuse.powersuits.gui.hud.FluidMeter;
import net.machinemuse.powersuits.gui.hud.HeatMeter;
import net.machinemuse.powersuits.gui.hud.PlasmaChargeMeter;
import net.machinemuse.powersuits.gui.hud.WaterMeter;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableKeybinding;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.machinemuse.powersuits.network.MPSPackets;
import net.machinemuse.powersuits.network.packets.MusePacketPlayerUpdate;
import net.machinemuse.powersuits.utils.MuseStringUtils;
import net.machinemuse.powersuits.utils.modulehelpers.AutoFeederHelper;
import net.machinemuse.powersuits.utils.modulehelpers.FluidUtils;
import net.machinemuse.powersuits.utils.modulehelpers.PlasmaCannonHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientTickHandler {
    public ArrayList<String> modules;
    protected HeatMeter heat = null;
    protected HeatMeter energy = null;
    protected WaterMeter water = null;
    protected FluidMeter fluidMeter = null;
    protected PlasmaChargeMeter plasma = null;
    private FluidUtils waterUtils;
    private FluidUtils fluidUtils;

    @SubscribeEvent
    public void onPreClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (ClickableKeybinding kb : KeybindManager.getKeybindings()) {
                kb.doToggleTick();
            }
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && MuseItemUtils.getModularItemsInInventory((EntityPlayer)player).size() > 0) {
                PlayerInputMap inputmap = PlayerInputMap.getInputMapFor(player.func_174793_f().func_70005_c_());
                inputmap.forwardKey = Math.signum(player.field_71158_b.field_192832_b);
                inputmap.strafeKey = Math.signum(player.field_71158_b.field_78902_a);
                inputmap.jumpKey = player.field_71158_b.field_78901_c;
                inputmap.sneakKey = player.field_71158_b.field_78899_d;
                inputmap.motionX = player.field_70159_w;
                inputmap.motionY = player.field_70181_x;
                inputmap.motionZ = player.field_70179_y;
                if (inputmap.hasChanged()) {
                    inputmap.refresh();
                    MPSPackets.sendToServer(new MusePacketPlayerUpdate((EntityPlayer)player, inputmap));
                }
            }
        }
    }

    public void findInstalledModules(EntityPlayer player) {
        if (player != null) {
            ItemStack powerfist;
            ItemStack chest;
            ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!helmet.func_190926_b() && helmet.func_77973_b() instanceof ItemPowerArmorHelmet) {
                if (ModuleManager.INSTANCE.itemHasActiveModule(helmet, "autoFeeder")) {
                    this.modules.add("autoFeeder");
                }
                if (ModuleManager.INSTANCE.itemHasActiveModule(helmet, "clock")) {
                    this.modules.add("clock");
                }
                if (ModuleManager.INSTANCE.itemHasActiveModule(helmet, "compass")) {
                    this.modules.add("compass");
                }
            }
            if (!(chest = player.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemPowerArmorChestplate) {
                if (ModuleManager.INSTANCE.itemHasActiveModule(chest, "basicCoolingSystem")) {
                    this.modules.add("basicCoolingSystem");
                }
                if (ModuleManager.INSTANCE.itemHasActiveModule(chest, "advancedCoolingSystem")) {
                    this.modules.add("advancedCoolingSystem");
                }
            }
            if (!(powerfist = player.func_184614_ca()).func_190926_b() && powerfist.func_77973_b() instanceof ItemPowerFist && ModuleManager.INSTANCE.itemHasActiveModule(powerfist, "plasmaCannon")) {
                this.modules.add("plasmaCannon");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        int yBaseString;
        double yBaseIcon;
        ItemStack food = new ItemStack(Items.field_151083_be);
        ItemStack clock = new ItemStack(Items.field_151113_aN);
        ItemStack compass = new ItemStack(Items.field_151111_aL);
        int yOffsetString = 18;
        double yOffsetIcon = 16.0;
        if (MPSConfig.INSTANCE.useGraphicalMeters()) {
            yBaseIcon = 150.0;
            yBaseString = 155;
        } else {
            yBaseIcon = 26.0;
            yBaseString = 32;
        }
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.modules = new ArrayList();
            this.findInstalledModules((EntityPlayer)player);
            if (player != null) {
                Minecraft.func_71410_x();
                if (Minecraft.func_71382_s() && MuseItemUtils.getModularItemsEquipped((EntityPlayer)player).size() > 0 && Minecraft.func_71410_x().field_71462_r == null) {
                    Minecraft mc = Minecraft.func_71410_x();
                    ScaledResolution screen = new ScaledResolution(mc);
                    for (int i = 0; i < this.modules.size(); ++i) {
                        if (Objects.equals(this.modules.get(i), "autoFeeder")) {
                            int foodLevel = (int)AutoFeederHelper.getFoodLevel(player.func_184582_a(EntityEquipmentSlot.HEAD));
                            String num = MuseStringUtils.formatNumberShort(foodLevel);
                            if (i == 0) {
                                MuseRenderer.drawString(num, 17.0, yBaseString);
                                MuseRenderer.drawItemAt(-1.0, yBaseIcon, food);
                                continue;
                            }
                            MuseRenderer.drawString(num, 17.0, yBaseString + yOffsetString * i);
                            MuseRenderer.drawItemAt(-1.0, yBaseIcon + yOffsetIcon * (double)i, food);
                            continue;
                        }
                        if (Objects.equals(this.modules.get(i), "clock")) {
                            String ampm;
                            long time = player.field_70170_p.field_73011_w.getWorldTime();
                            long hour = time % 24000L / 1000L;
                            if (MPSConfig.INSTANCE.use24hClock()) {
                                hour = hour < 19L ? (hour += 6L) : (hour -= 18L);
                                ampm = "h";
                            } else if (hour < 6L) {
                                hour += 6L;
                                ampm = " AM";
                            } else if (hour == 6L) {
                                hour = 12L;
                                ampm = " PM";
                            } else if (hour > 6L && hour < 18L) {
                                hour -= 6L;
                                ampm = " PM";
                            } else if (hour == 18L) {
                                hour = 12L;
                                ampm = " AM";
                            } else {
                                hour -= 18L;
                                ampm = " AM";
                            }
                            if (i == 0) {
                                MuseRenderer.drawString(hour + ampm, 17.0, yBaseString);
                                MuseRenderer.drawItemAt(-1.0, yBaseIcon, clock);
                                continue;
                            }
                            MuseRenderer.drawString(hour + ampm, 17.0, yBaseString + yOffsetString * i);
                            MuseRenderer.drawItemAt(-1.0, yBaseIcon + yOffsetIcon * (double)i, clock);
                            continue;
                        }
                        if (Objects.equals(this.modules.get(i), "compass")) {
                            if (i == 0) {
                                MuseRenderer.drawItemAt(-1.0, yBaseIcon, compass);
                                continue;
                            }
                            MuseRenderer.drawItemAt(-1.0, yBaseIcon + yOffsetIcon * (double)i, compass);
                            continue;
                        }
                        if (Objects.equals(this.modules.get(i), "basicCoolingSystem")) {
                            this.waterUtils = new FluidUtils((EntityPlayer)player, player.func_184582_a(EntityEquipmentSlot.CHEST), "basicCoolingSystem");
                            continue;
                        }
                        if (!Objects.equals(this.modules.get(i), "advancedCoolingSystem")) continue;
                        this.fluidUtils = new FluidUtils((EntityPlayer)player, player.func_184582_a(EntityEquipmentSlot.CHEST), "advancedCoolingSystem");
                    }
                    this.drawMeters((EntityPlayer)player, screen);
                }
            }
        }
    }

    private void drawMeters(EntityPlayer player, ScaledResolution screen) {
        double top = (double)screen.func_78328_b() / 2.0 - 16.0;
        double left = screen.func_78326_a() - 34;
        double maxEnergy = ElectricItemUtils.getMaxPlayerEnergy(player);
        double currEnergy = ElectricItemUtils.getPlayerEnergy(player);
        String currEnergyStr = MuseStringUtils.formatNumberShort(currEnergy) + "RF";
        String maxEnergyStr = MuseStringUtils.formatNumberShort(maxEnergy);
        double maxHeat = MuseHeatUtils.getPlayerMaxHeat(player);
        double currHeat = MuseHeatUtils.getPlayerHeat(player);
        String currHeatStr = MuseStringUtils.formatNumberShort(currHeat);
        String maxHeatStr = MuseStringUtils.formatNumberShort(maxHeat);
        double maxWater = 0.0;
        double currWater = 0.0;
        String currWaterStr = "";
        String maxWaterStr = "";
        if (this.waterUtils != null) {
            maxWater = this.waterUtils.getMaxFluidLevel();
            currWater = this.waterUtils.getFluidLevel();
            currWaterStr = MuseStringUtils.formatNumberShort(currWater);
            maxWaterStr = MuseStringUtils.formatNumberShort(maxWater);
        }
        double maxFluid = 0.0;
        double currFluid = 0.0;
        String currFluidStr = "";
        String maxFluidStr = "";
        if (ModuleManager.INSTANCE.itemHasModule(player.func_184582_a(EntityEquipmentSlot.CHEST), "advancedCoolingSystem")) {
            this.fluidUtils = new FluidUtils(player, player.func_184582_a(EntityEquipmentSlot.CHEST), "advancedCoolingSystem");
            maxFluid = this.fluidUtils.getMaxFluidLevel();
            currFluid = this.fluidUtils.getFluidLevel();
            currFluidStr = MuseStringUtils.formatNumberShort(currWater);
            maxFluidStr = MuseStringUtils.formatNumberShort(maxWater);
        }
        double maxPlasma = PlasmaCannonHelper.getMaxPlasma(player);
        double currPlasma = PlasmaCannonHelper.getPlayerPlasma(player);
        String currPlasmaStr = MuseStringUtils.formatNumberShort(currPlasma);
        String maxPlasmaStr = MuseStringUtils.formatNumberShort(maxPlasma);
        if (MPSConfig.INSTANCE.useGraphicalMeters()) {
            int numMeters = 0;
            if (maxEnergy > 0.0) {
                ++numMeters;
                if (this.energy == null) {
                    this.energy = new EnergyMeter();
                }
            } else {
                this.energy = null;
            }
            if (maxHeat > 0.0) {
                ++numMeters;
                if (this.heat == null) {
                    this.heat = new HeatMeter();
                }
            } else {
                this.heat = null;
            }
            if (maxWater > 0.0) {
                ++numMeters;
                if (this.water == null) {
                    this.water = new WaterMeter();
                }
            } else {
                this.water = null;
            }
            if (maxFluid > 0.0) {
                ++numMeters;
                if (this.fluidMeter == null) {
                    this.fluidMeter = this.fluidUtils.getFluidMeter();
                }
            }
            if (maxPlasma > 0.0) {
                ++numMeters;
                if (this.plasma == null) {
                    this.plasma = new PlasmaChargeMeter();
                }
            } else {
                this.plasma = null;
            }
            double stringX = left - 2.0;
            int totalMeters = numMeters;
            if (this.energy != null) {
                this.energy.draw(left, top + (double)((totalMeters - numMeters) * 8), currEnergy / maxEnergy);
                MuseRenderer.drawRightAlignedString(currEnergyStr, stringX, top);
                --numMeters;
            }
            this.heat.draw(left, top + (double)((totalMeters - numMeters) * 8), MuseMathUtils.clampDouble(currHeat, 0.0, maxHeat) / maxHeat);
            MuseRenderer.drawRightAlignedString(currHeatStr, stringX, top + (double)((totalMeters - numMeters) * 8));
            --numMeters;
            if (this.water != null) {
                this.water.draw(left, top + (double)((totalMeters - numMeters) * 8), currWater / maxWater);
                MuseRenderer.drawRightAlignedString(currWaterStr, stringX, top + (double)((totalMeters - numMeters) * 8));
                --numMeters;
            }
            if (this.fluidMeter != null) {
                this.fluidMeter.draw(left, top + (double)((totalMeters - numMeters) * 8), currFluid / maxFluid);
                MuseRenderer.drawRightAlignedString(currFluidStr, stringX, top + (double)((totalMeters - numMeters) * 8));
                --numMeters;
            }
            if (this.plasma != null) {
                this.plasma.draw(left, top + (double)((totalMeters - numMeters) * 8), currPlasma / maxPlasma);
                MuseRenderer.drawRightAlignedString(currPlasmaStr, stringX, top + (double)((totalMeters - numMeters) * 8));
            }
        } else {
            int numReadouts = 0;
            if (maxEnergy > 0.0) {
                MuseRenderer.drawString(currEnergyStr + '/' + maxEnergyStr + " \u1d60", 2.0, 2.0);
                ++numReadouts;
            }
            MuseRenderer.drawString(currHeatStr + '/' + maxHeatStr + " C", 2.0, 2 + numReadouts * 9);
            ++numReadouts;
            if (maxWater > 0.0) {
                MuseRenderer.drawString(currWaterStr + '/' + maxWaterStr + " buckets", 2.0, 2 + numReadouts * 9);
                ++numReadouts;
            }
            if (maxFluid > 0.0) {
                MuseRenderer.drawString(currFluidStr + '/' + maxFluidStr + " buckets", 2.0, 2 + numReadouts * 9);
                ++numReadouts;
            }
            if (maxPlasma > 0.0) {
                MuseRenderer.drawString(currPlasmaStr + '/' + maxPlasmaStr + "%", 2.0, 2 + numReadouts * 9);
            }
        }
    }
}

