/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.util.Objects;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.SpecBase;
import net.machinemuse.powersuits.client.render.modelspec.SpecBinding;
import net.minecraft.nbt.NBTTagCompound;

public abstract class PartSpecBase {
    public final SpecBase spec;
    final String partName;
    final SpecBinding binding;
    Integer defaultcolourindex;

    public PartSpecBase(SpecBase spec, SpecBinding binding, String partName, Integer defaultcolourindex) {
        this.spec = spec;
        this.partName = partName;
        this.binding = binding;
        this.defaultcolourindex = defaultcolourindex != null && defaultcolourindex >= 0 ? defaultcolourindex : Integer.valueOf(0);
    }

    public SpecBinding getBinding() {
        return this.binding;
    }

    public abstract String getDisaplayName();

    public int getColourIndex(NBTTagCompound nbt) {
        return nbt.func_74764_b("colourindex") ? nbt.func_74762_e("colourindex") : this.defaultcolourindex.intValue();
    }

    public void setColourIndex(NBTTagCompound nbt, int c) {
        if (c == this.defaultcolourindex) {
            nbt.func_82580_o("colourindex");
        } else {
            nbt.func_74768_a("colourindex", c);
        }
    }

    public void setModel(NBTTagCompound nbt, SpecBase model) {
        String modelString = (String)ModelRegistry.getInstance().getName(model);
        this.setModel(nbt, modelString != null ? modelString : "");
    }

    public void setModel(NBTTagCompound nbt, String modelname) {
        nbt.func_74778_a("model", modelname);
    }

    public void setPart(NBTTagCompound nbt) {
        nbt.func_74778_a("part", this.partName);
    }

    public NBTTagCompound multiSet(NBTTagCompound nbt, Integer colourIndex) {
        this.setPart(nbt);
        this.setModel(nbt, this.spec);
        this.setColourIndex(nbt, colourIndex != null ? colourIndex : this.defaultcolourindex);
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartSpecBase that = (PartSpecBase)o;
        return Objects.equals(this.spec, that.spec) && Objects.equals(this.partName, that.partName) && Objects.equals(this.binding, that.binding) && Objects.equals(this.defaultcolourindex, that.defaultcolourindex);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.partName, this.binding, this.defaultcolourindex);
    }
}

