/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import net.machinemuse.numina.module.IBlockBreakingModule;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.machinemuse.powersuits.utils.MusePlayerUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HarvestEventHandler {
    @SubscribeEvent
    public void handleHarvestCheck(PlayerEvent.HarvestCheck event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemPowerFist) {
            IBlockState state = event.getTargetBlock();
            if (state == null) {
                return;
            }
            RayTraceResult rayTraceResult = MusePlayerUtils.raytraceBlocks(player.field_70170_p, player, true, 10.0);
            if (rayTraceResult == null) {
                return;
            }
            BlockPos pos = rayTraceResult.func_178782_a();
            if (pos == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            if (state.func_177230_c() == null) {
                return;
            }
            int playerEnergy = ElectricItemUtils.getPlayerEnergy(player);
            event.setCanHarvest(((ItemPowerFist)stack.func_77973_b()).canHarvestBlock(stack, state, player, pos, playerEnergy));
        }
    }

    @SubscribeEvent
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        IBlockState state = event.getState();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemPowerFist) {
            if (event.getNewSpeed() < event.getOriginalSpeed()) {
                event.setNewSpeed(event.getOriginalSpeed());
            }
            int playerEnergy = ElectricItemUtils.getPlayerEnergy(player);
            for (IPowerModule module : ModuleManager.INSTANCE.getModulesOfType(IBlockBreakingModule.class)) {
                if (!ModuleManager.INSTANCE.itemHasActiveModule(stack, module.getDataName()) || !((IBlockBreakingModule)module).canHarvestBlock(stack, state, player, event.getPos(), playerEnergy)) continue;
                if (event.getNewSpeed() == 0.0f) {
                    event.setNewSpeed(1.0f);
                }
                ((IBlockBreakingModule)module).handleBreakSpeed(event);
            }
        }
    }
}

