/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.config.NuminaConfig;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.utils.heat.MuseHeatUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerUpdateHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            double currHeat;
            EntityPlayer player = (EntityPlayer)e.getEntity();
            NonNullList<ItemStack> modularItemsEquipped = MuseItemUtils.getModularItemsEquipped(player);
            for (ItemStack itemStack : modularItemsEquipped) {
                for (IPowerModule module : ModuleManager.INSTANCE.getModulesOfType(IPlayerTickModule.class)) {
                    if (!ModuleManager.INSTANCE.isValidForItem(itemStack, module) || !ModuleManager.INSTANCE.itemHasModule(itemStack, module.getDataName())) continue;
                    if (ModuleManager.INSTANCE.isModuleOnline(itemStack, module.getDataName())) {
                        ((IPlayerTickModule)module).onPlayerTickActive(player, itemStack);
                        continue;
                    }
                    ((IPlayerTickModule)module).onPlayerTickInactive(player, itemStack);
                }
            }
            if (modularItemsEquipped.size() > 0) {
                player.field_70143_R = (float)MovementManager.computeFallHeightFromVelocity(MuseMathUtils.clampDouble(player.field_70181_x, -1000.0, 0.0));
                double velsq2 = MuseMathUtils.sumsq(player.field_70159_w, player.field_70181_x, player.field_70179_y) - 0.5;
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    if (player.field_70160_al && velsq2 > 0.0) {
                        Musique.playerSound(player, SoundDictionary.SOUND_EVENT_GLIDER, SoundCategory.PLAYERS, (float)(velsq2 / 3.0), Float.valueOf(1.0f), (Boolean)true);
                    } else {
                        Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_GLIDER);
                    }
                }
            } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_GLIDER);
            }
            NonNullList<ItemStack> modularItemsInInventory = MuseItemUtils.getModularItemsInInventory(player);
            if (modularItemsInInventory.size() > 0 && (currHeat = MuseHeatUtils.getPlayerHeat(player)) >= 0.0 && !player.field_70170_p.field_72995_K) {
                double maxHeat;
                double coolPlayerAmount = MusePlayerUtils.getPlayerCoolingBasedOnMaterial(player) * 0.55;
                if (coolPlayerAmount > 0.0) {
                    MuseHeatUtils.coolPlayer(player, coolPlayerAmount);
                }
                if (currHeat > (maxHeat = MuseHeatUtils.getPlayerMaxHeat(player))) {
                    player.func_70097_a(MuseHeatUtils.overheatDamage, (float)(Math.sqrt(currHeat - maxHeat) / 4.0));
                    player.func_70015_d(1);
                } else {
                    player.func_70066_B();
                }
            }
        }
    }
}

