/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.utils.MuseLogger;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.numina.utils.math.geometry.MuseRect;
import net.machinemuse.numina.utils.math.geometry.MuseRelativeRect;
import net.machinemuse.numina.utils.nbt.MuseNBTUtils;
import net.machinemuse.numina.utils.render.MuseRenderer;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.PartSpecBase;
import net.machinemuse.powersuits.client.render.modelspec.SpecBase;
import net.machinemuse.powersuits.client.render.modelspec.TexturePartSpec;
import net.machinemuse.powersuits.gui.GuiIcons;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableItem;
import net.machinemuse.powersuits.gui.tinker.frame.ColourPickerFrame;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.machinemuse.powersuits.item.armor.ItemPowerArmor;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.machinemuse.powersuits.network.MPSPackets;
import net.machinemuse.powersuits.network.packets.MusePacketCosmeticInfo;
import net.machinemuse.powersuits.utils.nbt.MPSNBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PartSpecManipSubFrame {
    public SpecBase model;
    public ColourPickerFrame colourframe;
    public ItemSelectionFrame itemSelector;
    public MuseRelativeRect border;
    public List<PartSpecBase> partSpecs;
    public boolean open;

    public PartSpecManipSubFrame(SpecBase model, ColourPickerFrame colourframe, ItemSelectionFrame itemSelector, MuseRelativeRect border) {
        this.model = model;
        this.colourframe = colourframe;
        this.itemSelector = itemSelector;
        this.border = border;
        this.partSpecs = this.getPartSpecs();
        this.open = true;
    }

    private List<PartSpecBase> getPartSpecs() {
        ArrayList<PartSpecBase> specsArray = new ArrayList<PartSpecBase>();
        for (PartSpecBase spec : this.model.getPartSpecs()) {
            if (!this.isValidItem(this.getSelectedItem(), spec.getBinding().getSlot())) continue;
            specsArray.add(spec);
        }
        return specsArray;
    }

    public boolean isValidItem(ClickableItem clickie, EntityEquipmentSlot slot) {
        if (clickie != null) {
            if (clickie.getItem().func_77973_b() instanceof ItemPowerArmor) {
                return clickie.getItem().func_77973_b().isValidArmor(clickie.getItem(), slot, (Entity)Minecraft.func_71410_x().field_71439_g);
            }
            if (clickie.getItem().func_77973_b() instanceof ItemPowerFist && slot.func_188453_a().equals((Object)EntityEquipmentSlot.Type.HAND)) {
                return true;
            }
        }
        return false;
    }

    public ClickableItem getSelectedItem() {
        return this.itemSelector.getSelectedItem();
    }

    public EntityEquipmentSlot getEquipmentSlot() {
        ItemStack selectedItem = this.getSelectedItem().getItem();
        if (!selectedItem.func_190926_b() && selectedItem.func_77973_b() instanceof ItemPowerArmor) {
            return ((ItemPowerArmor)selectedItem.func_77973_b()).field_77881_a;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack heldItem = player.func_184592_cb();
        if (!heldItem.func_190926_b() && MuseItemUtils.stackEqualExact(selectedItem, heldItem)) {
            return EntityEquipmentSlot.OFFHAND;
        }
        return EntityEquipmentSlot.MAINHAND;
    }

    public NBTTagCompound getRenderTag() {
        return MPSNBTUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getEquipmentSlot());
    }

    public NBTTagCompound getItemTag() {
        return MuseNBTUtils.getMuseItemTag(this.getSelectedItem().getItem());
    }

    @Nullable
    public NBTTagCompound getOrDontGetSpecTag(PartSpecBase partSpec) {
        if (partSpec instanceof ModelPartSpec) {
            String name = ModelRegistry.getInstance().makeName(partSpec);
            return this.getRenderTag().func_74764_b(name) ? this.getRenderTag().func_74775_l(name) : null;
        }
        if (partSpec instanceof TexturePartSpec && this.getRenderTag().func_74764_b("texSpec")) {
            NBTTagCompound texSpecTag = this.getRenderTag().func_74775_l("texSpec");
            if (partSpec.spec.getOwnName().equals(texSpecTag.func_74779_i("model"))) {
                return this.getRenderTag().func_74775_l("texSpec");
            }
        }
        return null;
    }

    public NBTTagCompound getSpecTag(PartSpecBase partSpec) {
        NBTTagCompound nbt = this.getOrDontGetSpecTag(partSpec);
        return nbt != null ? nbt : new NBTTagCompound();
    }

    public NBTTagCompound getOrMakeSpecTag(PartSpecBase partSpec) {
        NBTTagCompound nbt = this.getSpecTag(partSpec);
        if (nbt.func_82582_d()) {
            String name;
            if (partSpec instanceof ModelPartSpec) {
                name = ModelRegistry.getInstance().makeName(partSpec);
                ((ModelPartSpec)partSpec).multiSet(nbt, null, null);
            } else {
                name = "texSpec";
                partSpec.multiSet(nbt, null);
            }
            this.getRenderTag().func_74782_a(name, (NBTBase)nbt);
        }
        return nbt;
    }

    public void updateItems() {
        this.partSpecs = this.getPartSpecs();
        this.border.setHeight(this.partSpecs.size() > 0 ? (double)(this.partSpecs.size() * 8 + 10) : 0.0);
    }

    public void drawPartial(double min, double max) {
        if (this.partSpecs.size() > 0) {
            MuseRenderer.drawString(this.model.getDisaplayName(), this.border.left() + 8.0, this.border.top());
            this.drawOpenArrow(min, max);
            if (this.open) {
                int y = (int)(this.border.top() + 8.0);
                for (PartSpecBase spec : this.partSpecs) {
                    this.drawSpecPartial(this.border.left(), y, spec, min, max);
                    y += 8;
                }
            }
        }
    }

    public void decrAbove(int index) {
        for (PartSpecBase spec : this.partSpecs) {
            int oldindex;
            String tagname = ModelRegistry.getInstance().makeName(spec);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound tagdata = this.getOrDontGetSpecTag(spec);
            if (tagdata == null || (oldindex = spec.getColourIndex(tagdata)) < index || oldindex <= 0) continue;
            spec.setColourIndex(tagdata, oldindex - 1);
            if (!player.field_70170_p.field_72995_K) continue;
            MPSPackets.sendToServer(new MusePacketCosmeticInfo((EntityPlayer)player, this.getSelectedItem().inventorySlot, tagname, tagdata));
        }
    }

    public void drawSpecPartial(double x, double y, PartSpecBase partSpec, double ymino, double ymaxo) {
        NBTTagCompound tag = this.getSpecTag(partSpec);
        int selcomp = tag.func_82582_d() ? 0 : (partSpec instanceof ModelPartSpec && ((ModelPartSpec)partSpec).getGlow(tag) ? 2 : 1);
        int selcolour = partSpec.getColourIndex(tag);
        new GuiIcons.TransparentArmor(x, y, null, null, ymino, null, ymaxo);
        new GuiIcons.NormalArmor(x + 8.0, y, null, null, ymino, null, ymaxo);
        if (partSpec instanceof ModelPartSpec) {
            new GuiIcons.GlowArmor(x + 16.0, y, null, null, ymino, null, ymaxo);
        }
        new GuiIcons.SelectedArmorOverlay(x + (double)(selcomp * 8), y, null, null, ymino, null, ymaxo);
        double acc = x + 28.0;
        for (int colour : this.colourframe.colours()) {
            new GuiIcons.ArmourColourPatch(acc, y, new Colour(colour), null, ymino, null, ymaxo);
            acc += 8.0;
        }
        double textstartx = acc;
        if (selcomp > 0) {
            new GuiIcons.SelectedArmorOverlay(x + 28.0 + (double)(selcolour * 8), y, null, null, ymino, null, ymaxo);
        }
        MuseRenderer.drawString(partSpec.getDisaplayName(), textstartx + 4.0, y);
    }

    public void drawOpenArrow(double min, double max) {
        RenderState.texturelessOn();
        Colour.LIGHTBLUE.doGL();
        GL11.glBegin((int)4);
        if (this.open) {
            GL11.glVertex2d((double)(this.border.left() + 3.0), (double)MuseMathUtils.clampDouble(this.border.top() + 3.0, min, max));
            GL11.glVertex2d((double)(this.border.left() + 5.0), (double)MuseMathUtils.clampDouble(this.border.top() + 7.0, min, max));
            GL11.glVertex2d((double)(this.border.left() + 7.0), (double)MuseMathUtils.clampDouble(this.border.top() + 3.0, min, max));
        } else {
            GL11.glVertex2d((double)(this.border.left() + 3.0), (double)MuseMathUtils.clampDouble(this.border.top() + 3.0, min, max));
            GL11.glVertex2d((double)(this.border.left() + 3.0), (double)MuseMathUtils.clampDouble(this.border.top() + 7.0, min, max));
            GL11.glVertex2d((double)(this.border.left() + 7.0), (double)MuseMathUtils.clampDouble(this.border.top() + 5.0, min, max));
        }
        GL11.glEnd();
        Colour.WHITE.doGL();
        RenderState.texturelessOff();
    }

    public MuseRect getBorder() {
        if (this.open) {
            this.border.setHeight(9 + 9 * this.partSpecs.size());
        } else {
            this.border.setHeight(9.0);
        }
        return this.border;
    }

    public boolean tryMouseClick(double x, double y) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (x < this.border.left() || x > this.border.right() || y < this.border.top() || y > this.border.bottom()) {
            return false;
        }
        if (x > this.border.left() + 2.0 && x < this.border.left() + 8.0 && y > this.border.top() + 2.0 && y < this.border.top() + 8.0) {
            this.open = !this.open;
            this.getBorder();
            return true;
        }
        if (x < this.border.left() + 24.0 && y > this.border.top() + 8.0) {
            int lineNumber = (int)((y - this.border.top() - 8.0) / 8.0);
            int columnNumber = (int)((x - this.border.left()) / 8.0);
            PartSpecBase spec = this.partSpecs.get(Math.max(Math.min(lineNumber, this.partSpecs.size() - 1), 0));
            MuseLogger.logDebug("Line " + lineNumber + " Column " + columnNumber);
            switch (columnNumber) {
                case 0: {
                    String tagname = spec instanceof TexturePartSpec ? "texSpec" : ModelRegistry.getInstance().makeName(spec);
                    if (player.field_70170_p.field_72995_K) {
                        MPSPackets.sendToServer(new MusePacketCosmeticInfo((EntityPlayer)player, this.getSelectedItem().inventorySlot, tagname, new NBTTagCompound()));
                    }
                    this.updateItems();
                    return true;
                }
                case 1: {
                    String tagname = spec instanceof TexturePartSpec ? "texSpec" : ModelRegistry.getInstance().makeName(spec);
                    NBTTagCompound tagdata = this.getOrMakeSpecTag(spec);
                    if (spec instanceof ModelPartSpec) {
                        ((ModelPartSpec)spec).setGlow(tagdata, false);
                    }
                    if (player.field_70170_p.field_72995_K) {
                        MPSPackets.sendToServer(new MusePacketCosmeticInfo((EntityPlayer)player, this.getSelectedItem().inventorySlot, tagname, tagdata));
                    }
                    this.updateItems();
                    return true;
                }
                case 2: {
                    if (spec instanceof ModelPartSpec) {
                        String tagname = ModelRegistry.getInstance().makeName(spec);
                        NBTTagCompound tagdata = this.getOrMakeSpecTag(spec);
                        ((ModelPartSpec)spec).setGlow(tagdata, true);
                        if (player.field_70170_p.field_72995_K) {
                            MPSPackets.sendToServer(new MusePacketCosmeticInfo((EntityPlayer)player, this.getSelectedItem().inventorySlot, tagname, tagdata));
                        }
                        this.updateItems();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        if (x > this.border.left() + 28.0 && x < this.border.left() + 28.0 + (double)(this.colourframe.colours().length * 8)) {
            int lineNumber = (int)((y - this.border.top() - 8.0) / 8.0);
            int columnNumber = (int)((x - this.border.left() - 28.0) / 8.0);
            PartSpecBase spec = this.partSpecs.get(Math.max(Math.min(lineNumber, this.partSpecs.size() - 1), 0));
            String tagname = spec instanceof TexturePartSpec ? "texSpec" : ModelRegistry.getInstance().makeName(spec);
            NBTTagCompound tagdata = this.getOrMakeSpecTag(spec);
            spec.setColourIndex(tagdata, columnNumber);
            if (player.field_70170_p.field_72995_K) {
                MPSPackets.sendToServer(new MusePacketCosmeticInfo((EntityPlayer)player, this.getSelectedItem().inventorySlot, tagname, tagdata));
            }
            return true;
        }
        return false;
    }
}

