/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.environmental;

import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.utils.modulehelpers.AutoFeederHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FoodStats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AutoFeederModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public AutoFeederModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        this.addBasePropertyDouble("eatingEnergyCon", 100.0);
        this.addBasePropertyDouble("autoFeederEfficiency", 50.0);
        this.addTradeoffPropertyDouble("efficiency", "eatingEnergyCon", 1000.0, "RF");
        this.addTradeoffPropertyDouble("efficiency", "autoFeederEfficiency", 50.0);
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_ENVIRONMENTAL;
    }

    @Override
    public String getDataName() {
        return "autoFeeder";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        ItemFood food;
        ItemStack stack;
        int i;
        double foodLevel = AutoFeederHelper.getFoodLevel(item);
        double saturationLevel = AutoFeederHelper.getSaturationLevel(item);
        InventoryPlayer inv = player.field_71071_by;
        double eatingEnergyConsumption = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "eatingEnergyCon");
        double efficiency = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "autoFeederEfficiency");
        FoodStats foodStats = player.func_71024_bL();
        int foodNeeded = 20 - foodStats.func_75116_a();
        double saturationNeeded = 20.0f - foodStats.func_75115_e();
        if (MPSConfig.INSTANCE.useOldAutoFeeder()) {
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood)) continue;
                food = (ItemFood)stack.func_77973_b();
                for (int a = 0; a < stack.func_190916_E(); ++a) {
                    foodLevel += (double)food.func_150905_g(stack) * efficiency / 100.0;
                    saturationLevel += (double)Math.min((float)food.func_150905_g(stack) * food.func_150906_h(stack) * 2.0f, 20.0f) * efficiency / 100.0;
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            AutoFeederHelper.setFoodLevel(item, foodLevel);
            AutoFeederHelper.setSaturationLevel(item, saturationLevel);
        } else {
            block2: for (i = 0; i < inv.func_70302_i_() && !((double)foodNeeded < foodLevel); ++i) {
                stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood)) continue;
                food = (ItemFood)stack.func_77973_b();
                while ((double)foodNeeded > foodLevel) {
                    foodLevel += (double)food.func_150905_g(stack) * efficiency / 100.0;
                    saturationLevel += Math.min((double)food.func_150905_g(stack) * (double)food.func_150906_h(stack) * 2.0, 20.0) * efficiency / 100.0;
                    stack.func_190920_e(stack.func_190916_E() - 1);
                    if (stack.func_190916_E() == 0) {
                        player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                        continue block2;
                    }
                    player.field_71071_by.func_70299_a(i, stack);
                }
            }
            AutoFeederHelper.setFoodLevel(item, foodLevel);
            AutoFeederHelper.setSaturationLevel(item, saturationLevel);
        }
        NBTTagCompound foodStatNBT = new NBTTagCompound();
        if (foodNeeded > 0 && AutoFeederHelper.getFoodLevel(item) >= 1.0) {
            int foodUsed = 0;
            if (AutoFeederHelper.getFoodLevel(item) >= (double)foodNeeded && (double)foodNeeded * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy(player)) {
                foodUsed = foodNeeded;
            } else if ((double)foodNeeded - AutoFeederHelper.getFoodLevel(item) > 0.0 && AutoFeederHelper.getFoodLevel(item) * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy(player)) {
                foodUsed = (int)AutoFeederHelper.getFoodLevel(item);
            } else if (eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy(player) && AutoFeederHelper.getFoodLevel(item) >= 1.0) {
                foodUsed = 1;
            }
            if (foodUsed > 0) {
                foodStats.func_75117_b(foodStatNBT);
                foodStatNBT.func_74768_a("foodLevel", foodStatNBT.func_74762_e("foodLevel") + foodUsed);
                foodStats.func_75112_a(foodStatNBT);
                AutoFeederHelper.setFoodLevel(item, AutoFeederHelper.getFoodLevel(item) - (double)foodUsed);
                ElectricItemUtils.drainPlayerEnergy(player, (int)(eatingEnergyConsumption * 0.5 * (double)foodUsed));
                if (saturationNeeded >= 1.0) {
                    int saturationUsed = 0;
                    if (AutoFeederHelper.getSaturationLevel(item) >= saturationNeeded && saturationNeeded * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy(player)) {
                        saturationUsed = (int)saturationNeeded;
                    } else if (saturationNeeded - AutoFeederHelper.getSaturationLevel(item) > 0.0 && AutoFeederHelper.getSaturationLevel(item) * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy(player)) {
                        saturationUsed = (int)AutoFeederHelper.getSaturationLevel(item);
                    } else if (eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy(player) && AutoFeederHelper.getSaturationLevel(item) >= 1.0) {
                        saturationUsed = 1;
                    }
                    if (saturationUsed > 0) {
                        foodStats.func_75117_b(foodStatNBT);
                        foodStatNBT.func_74776_a("foodSaturationLevel", foodStatNBT.func_74760_g("foodSaturationLevel") + (float)saturationUsed);
                        foodStats.func_75112_a(foodStatNBT);
                        AutoFeederHelper.setSaturationLevel(item, AutoFeederHelper.getSaturationLevel(item) - (double)saturationUsed);
                        ElectricItemUtils.drainPlayerEnergy(player, (int)(eatingEnergyConsumption * 0.5 * (double)saturationUsed));
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.autoFeeder;
    }
}

