/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.config.NuminaConfig;
import net.machinemuse.numina.control.PlayerInputMap;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.utils.MusePlayerUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;

public class JetPackModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public JetPackModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 4));
        this.addBasePropertyDouble("jetpackEnergyCon", 0.0, "RF/t");
        this.addBasePropertyDouble("jetpackThrust", 0.0, "N");
        this.addTradeoffPropertyDouble("thrust", "jetpackEnergyCon", 1500.0);
        this.addTradeoffPropertyDouble("thrust", "jetpackThrust", 0.16);
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    @Override
    public String getDataName() {
        return "jetpack";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (player.func_70090_H()) {
            return;
        }
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.func_174793_f().func_70005_c_());
        boolean jumpkey = movementInput.jumpKey;
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        boolean hasFlightControl = !helmet.func_190926_b() && helmet.func_77973_b() instanceof IModularItem && ModuleManager.INSTANCE.itemHasActiveModule(helmet, "flightControl");
        double jetEnergy = 0.0;
        double thrust = 0.0;
        jetEnergy += ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "jetpackEnergyCon");
        thrust += ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "jetpackThrust");
        if (jetEnergy < (double)ElectricItemUtils.getPlayerEnergy(player)) {
            if (hasFlightControl && thrust > 0.0) {
                thrust = MusePlayerUtils.thrust(player, thrust, true);
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    Musique.playerSound(player, SoundDictionary.SOUND_EVENT_JETPACK, SoundCategory.PLAYERS, (float)(thrust * 6.25), Float.valueOf(1.0f), (Boolean)true);
                }
                ElectricItemUtils.drainPlayerEnergy(player, (int)(thrust * jetEnergy));
            } else if (jumpkey) {
                thrust = MusePlayerUtils.thrust(player, thrust, false);
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    Musique.playerSound(player, SoundDictionary.SOUND_EVENT_JETPACK, SoundCategory.PLAYERS, (float)(thrust * 6.25), Float.valueOf(1.0f), (Boolean)true);
                }
                ElectricItemUtils.drainPlayerEnergy(player, (int)(thrust * jetEnergy));
            } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_JETPACK);
            }
        } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_JETPACK);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_JETPACK);
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.jetpack;
    }
}

