/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import com.google.common.collect.HashMultimap;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.nbt.MuseNBTUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SprintAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public SprintAssistModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 4));
        this.addBasePropertyDouble("sprintEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("sprintAssist", "sprintEnergyCon", 100.0);
        this.addBasePropertyDouble("sprintSpeedMult", 0.01, "%");
        this.addTradeoffPropertyDouble("sprintAssist", "sprintSpeedMult", 2.49);
        this.addBasePropertyDouble("sprintEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("compensation", "sprintEnergyCon", 20.0);
        this.addBasePropertyDouble("sprintExComp", 0.0, "%");
        this.addTradeoffPropertyDouble("compensation", "sprintExComp", 1.0);
        this.addBasePropertyDouble("walkingEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("walkingAssist", "walkingEnergyCon", 100.0);
        this.addBasePropertyDouble("walkingSpeedMult", 0.01, "%");
        this.addTradeoffPropertyDouble("walkingAssist", "walkingSpeedMult", 1.99);
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack itemStack) {
        ItemStack armorLeggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
        if (!armorLeggings.func_190926_b() && armorLeggings.func_77973_b() instanceof ItemPowerArmorLeggings) {
            double horzMovement = player.field_70140_Q - player.field_70141_P;
            double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
            if (horzMovement > 0.0) {
                if (player.func_70051_ag()) {
                    double exhaustion = (double)Math.round(horzMovement * 100.0) * 0.01;
                    double sprintCost = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "sprintEnergyCon");
                    if (sprintCost < totalEnergy) {
                        double sprintMultiplier = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "sprintSpeedMult");
                        double exhaustionComp = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "sprintExComp");
                        ElectricItemUtils.drainPlayerEnergy(player, (int)(sprintCost * horzMovement * 5.0));
                        this.setMovementModifier(itemStack, sprintMultiplier);
                        player.func_71024_bL().func_75113_a((float)(-0.01 * exhaustion * exhaustionComp));
                        player.field_70747_aH = player.func_70689_ay() * 0.2f;
                    }
                } else {
                    double cost = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "walkingEnergyCon");
                    if (cost < totalEnergy) {
                        double walkMultiplier = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "walkingSpeedMult");
                        ElectricItemUtils.drainPlayerEnergy(player, (int)(cost * horzMovement * 5.0));
                        this.setMovementModifier(itemStack, walkMultiplier);
                        player.field_70747_aH = player.func_70689_ay() * 0.2f;
                    }
                }
            }
        } else {
            this.onPlayerTickInactive(player, itemStack);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack itemStack) {
        this.setMovementModifier(itemStack, 0.0);
    }

    public void setMovementModifier(ItemStack itemStack, double multiplier) {
        NBTTagCompound itemNBT = MuseNBTUtils.getNBTTag(itemStack);
        boolean hasAttribute = false;
        if (itemNBT.func_150297_b("AttributeModifiers", 9)) {
            HashMultimap multimap = HashMultimap.create();
            NBTTagList nbttaglist = itemNBT.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound attributeTag = nbttaglist.func_150305_b(i);
                if (!attributeTag.func_74779_i("Name").equals(SharedMonsterAttributes.field_111263_d.func_111108_a())) continue;
                attributeTag.func_74780_a("Amount", multiplier);
                hasAttribute = true;
                break;
            }
        }
        if (!hasAttribute && multiplier > 0.0) {
            itemStack.func_185129_a(SharedMonsterAttributes.field_111263_d.func_111108_a(), new AttributeModifier(SharedMonsterAttributes.field_111263_d.func_111108_a(), multiplier, 0), EntityEquipmentSlot.LEGS);
        }
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    @Override
    public String getDataName() {
        return "sprintAssist";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.sprintAssist;
    }
}

