/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.client.renderer.SkyBlockRenderer;
import openblocks.common.block.BlockSky;
import openblocks.common.tileentity.TileEntitySky;
import openmods.renderer.CachedRendererFactory;
import openmods.utils.FakeBlockAccess;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class TileEntitySkyRenderer
extends TileEntitySpecialRenderer<TileEntitySky> {
    private CachedRendererFactory.CachedRenderer skyTextureRenderer = null;
    private final Map<IBlockState, CachedRendererFactory.CachedRenderer> renderers = Maps.newHashMap();

    public TileEntitySkyRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void render(TileEntitySky te, double x, double y, double z, float partialTickTime, int destroyStage, float alpha) {
        boolean stencilActive;
        BlockPos pos = te.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        if (!(state.func_177230_c() instanceof BlockSky) || !BlockSky.isActive(state)) {
            return;
        }
        SkyBlockRenderer.INSTANCE.incrementUsers();
        int stencilMask = SkyBlockRenderer.INSTANCE.getStencilMask();
        boolean bl = stencilActive = stencilMask >= 0 && SkyBlockRenderer.INSTANCE.hasSkyTexture();
        if (stencilActive) {
            GL11.glEnable((int)2960);
            GL11.glStencilMask((int)stencilMask);
            GL11.glStencilFunc((int)519, (int)stencilMask, (int)stencilMask);
            GL11.glStencilOp((int)7680, (int)7680, (int)7681);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        GlStateManager.func_179098_w();
        this.renderModel(x, y, z, pos, (IBlockAccess)world, state);
        if (stencilActive) {
            GL11.glStencilFunc((int)514, (int)stencilMask, (int)stencilMask);
            GL11.glStencilOp((int)0, (int)0, (int)0);
            SkyBlockRenderer.INSTANCE.bindSkyTexture();
            if (this.skyTextureRenderer == null) {
                this.skyTextureRenderer = TileEntitySkyRenderer.createSkyTextureRenderer();
            }
            TileEntitySkyRenderer.skyTextureRenderPre();
            this.skyTextureRenderer.render();
            TileEntitySkyRenderer.skyTextureRenderPost();
            GL11.glDisable((int)2960);
        }
    }

    private static CachedRendererFactory.CachedRenderer createSkyTextureRenderer() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(1.0, -1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        return new CachedRendererFactory().createRenderer(tessellator);
    }

    private static void skyTextureRenderPre() {
        GlStateManager.func_179106_n();
        RenderUtils.disableLightmap();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
    }

    private static void skyTextureRenderPost() {
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179141_d();
        GlStateManager.func_179129_p();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderUtils.enableLightmap();
        GlStateManager.func_179127_m();
    }

    private static CachedRendererFactory.CachedRenderer createRenderer(IBlockState state) {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        FakeBlockAccess fakeBlockAccess = new FakeBlockAccess(state);
        blockRenderer.func_175019_b().func_178267_a((IBlockAccess)fakeBlockAccess, model, state, FakeBlockAccess.ORIGIN, renderer, false);
        return new CachedRendererFactory().createRenderer(tessellator);
    }

    private void renderModel(double x, double y, double z, BlockPos pos, IBlockAccess world, IBlockState state) {
        this.func_147499_a(TextureMap.field_110575_b);
        CachedRendererFactory.CachedRenderer renderer = this.renderers.computeIfAbsent(state, TileEntitySkyRenderer::createRenderer);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        renderer.render();
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        for (CachedRendererFactory.CachedRenderer renderer : this.renderers.values()) {
            renderer.dispose();
        }
        this.renderers.clear();
        if (this.skyTextureRenderer != null) {
            this.skyTextureRenderer.dispose();
            this.skyTextureRenderer = null;
        }
    }
}

