/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import openblocks.OpenBlocks;
import openblocks.common.FluidXpUtils;
import openmods.OpenMods;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.BlockUtils;
import openmods.utils.CompatibilityUtils;
import openmods.utils.EnchantmentUtils;

public class TileEntityXPDrain
extends OpenTileEntity
implements ITickable {
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IFluidHandler maybeHandler;
            TileEntity te;
            BlockPos down;
            List<EntityXPOrb> xpOrbsOnGrid = this.getXPOrbsOnGrid();
            List<EntityPlayer> playersOnGrid = this.getPlayersOnGrid();
            if (!(xpOrbsOnGrid.isEmpty() && playersOnGrid.isEmpty() || !this.field_145850_b.func_175667_e(down = this.func_174877_v().func_177977_b()) || (te = this.field_145850_b.func_175625_s(down)) == null || te.func_145837_r() || (maybeHandler = CompatibilityUtils.getFluidHandler((TileEntity)te, (EnumFacing)EnumFacing.UP)) == null)) {
                for (EntityXPOrb orb : xpOrbsOnGrid) {
                    this.tryConsumeOrb(maybeHandler, orb);
                }
                for (EntityPlayer player : playersOnGrid) {
                    this.tryDrainPlayer(maybeHandler, player);
                }
            }
        }
    }

    protected void tryDrainPlayer(IFluidHandler tank, EntityPlayer player) {
        int acceptedLiquid;
        int playerXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
        if (playerXP <= 0) {
            return;
        }
        int maxDrainedXp = Math.min(4, playerXP);
        int xpAmount = FluidXpUtils.xpJuiceConverter.xpToFluid(maxDrainedXp);
        FluidStack xpStack = new FluidStack(OpenBlocks.Fluids.xpJuice, xpAmount);
        int maxAcceptedLiquid = tank.fill(xpStack, false);
        int acceptedXP = FluidXpUtils.xpJuiceConverter.fluidToXp(maxAcceptedLiquid);
        xpStack.amount = acceptedLiquid = FluidXpUtils.xpJuiceConverter.xpToFluid(acceptedXP);
        int finallyAcceptedLiquid = tank.fill(xpStack, true);
        if (finallyAcceptedLiquid <= 0) {
            return;
        }
        if (OpenMods.proxy.getTicks(this.field_145850_b) % 4L == 0L) {
            this.playSoundAtBlock(SoundEvents.field_187604_bf, 0.1f, 0.5f * ((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.7f + 1.8f));
        }
        EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)(-acceptedXP));
    }

    protected void tryConsumeOrb(IFluidHandler tank, EntityXPOrb orb) {
        int xpAmount;
        FluidStack xpStack;
        int filled;
        if (!orb.field_70128_L && (filled = tank.fill(xpStack = new FluidStack(OpenBlocks.Fluids.xpJuice, xpAmount = FluidXpUtils.xpJuiceConverter.xpToFluid(orb.func_70526_d())), false)) == xpStack.amount) {
            tank.fill(xpStack, true);
            orb.func_70106_y();
        }
    }

    protected List<EntityPlayer> getPlayersOnGrid() {
        return this.field_145850_b.func_72872_a(EntityPlayer.class, BlockUtils.singleBlock((BlockPos)this.field_174879_c));
    }

    protected List<EntityXPOrb> getXPOrbsOnGrid() {
        return this.field_145850_b.func_72872_a(EntityXPOrb.class, BlockUtils.aabbOffset((BlockPos)this.field_174879_c, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.3, (double)1.0));
    }
}

