/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.listener;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopConfig;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.shop.Shop;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PlayerClickListener {
    @Listener(order=Order.AFTER_PRE, beforeModifications=true)
    public void onPlayerRightClick(InteractBlockEvent.Secondary.MainHand event, @First Player player) {
        Optional optLoc = event.getTargetBlock().getLocation();
        if (!optLoc.isPresent()) {
            return;
        }
        Optional<List<Shop>> shops = ShopsData.getShops((Location<World>)((Location)optLoc.get()));
        if (shops.isPresent()) {
            if (ShopConfig.getNode("others", "emptyhand").getBoolean() && (player.getItemInHand(HandTypes.MAIN_HAND).isPresent() && ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).getType() != ItemTypes.AIR || player.getItemInHand(HandTypes.OFF_HAND).isPresent() && ((ItemStack)player.getItemInHand(HandTypes.OFF_HAND).get()).getType() != ItemTypes.AIR)) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_EMPTYHAND}));
                return;
            }
            shops.get().forEach(shop -> {
                if (shop.getLocation().equals(optLoc.get())) {
                    shop.trigger(player);
                    Sponge.getScheduler().createTaskBuilder().delayTicks(4L).execute(task -> {
                        shop.update();
                        task.cancel();
                    }).submit((Object)CarrotShop.getInstance());
                }
            });
        }
    }

    @Listener(order=Order.AFTER_PRE, beforeModifications=true)
    public void onPlayerLeftClickMaster(InteractBlockEvent.Primary.MainHand event, @First Player player) {
        Optional optLoc = event.getTargetBlock().getLocation();
        if (!optLoc.isPresent()) {
            return;
        }
        Optional<List<Shop>> shops = ShopsData.getShops((Location<World>)((Location)optLoc.get()));
        if (shops.isPresent()) {
            shops.get().forEach(shop -> {
                if (shop.getLocation().equals(optLoc.get())) {
                    shop.info(player);
                }
            });
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onPlayerLeftClickProtect(InteractBlockEvent.Primary.MainHand event, @First Player player) {
        Optional optItem;
        if (!((GameMode)player.gameMode().get()).equals(GameModes.CREATIVE)) {
            return;
        }
        Optional optLoc = event.getTargetBlock().getLocation();
        if (!optLoc.isPresent()) {
            return;
        }
        Optional<List<Shop>> shop = ShopsData.getShops((Location<World>)((Location)optLoc.get()));
        if (!(!shop.isPresent() || (optItem = player.getItemInHand(HandTypes.MAIN_HAND)).isPresent() && (((ItemStack)optItem.get()).getType().equals(ItemTypes.BEDROCK) || ((ItemStack)optItem.get()).getType().equals(ItemTypes.REDSTONE) || ((ItemStack)optItem.get()).getType().equals(ItemTypes.STICK)))) {
            event.setCancelled(true);
        }
    }

    @Listener(beforeModifications=true)
    public void onPlayerLeftClickNormal(InteractBlockEvent.Primary.MainHand event, @First Player player) {
        block6: {
            Optional<List<Shop>> optShop;
            Optional optItem;
            Optional optLoc;
            block4: {
                block5: {
                    optLoc = event.getTargetBlock().getLocation();
                    if (!optLoc.isPresent()) {
                        return;
                    }
                    optItem = player.getItemInHand(HandTypes.MAIN_HAND);
                    if (!optItem.isPresent() || !((ItemStack)optItem.get()).getType().equals(ItemTypes.REDSTONE)) break block4;
                    if (((Location)optLoc.get()).getBlockType() != BlockTypes.CHEST && ((Location)optLoc.get()).getBlockType() != BlockTypes.TRAPPED_CHEST && ((Location)optLoc.get()).getBlockType() != BlockTypes.LEVER) break block5;
                    event.setCancelled(true);
                    ShopsData.storeItemLocation(player, (Location<World>)((Location)optLoc.get()));
                    break block6;
                }
                if (((Location)optLoc.get()).getBlockType() != BlockTypes.STANDING_SIGN && ((Location)optLoc.get()).getBlockType() != BlockTypes.WALL_SIGN) break block6;
                event.setCancelled(true);
                Shop.build(player, (Location<World>)((Location)optLoc.get()));
                break block6;
            }
            if (ShopsData.hasMultipleCurrencies() && optItem.isPresent() && ((ItemStack)optItem.get()).getType().equals(ItemTypes.STICK) && (((Location)optLoc.get()).getBlockType() == BlockTypes.STANDING_SIGN || ((Location)optLoc.get()).getBlockType() == BlockTypes.WALL_SIGN) && (optShop = ShopsData.getShops((Location<World>)((Location)optLoc.get()))).isPresent()) {
                event.setCancelled(true);
                for (Shop shop : optShop.get()) {
                    if (!shop.canLoopCurrency(player)) continue;
                    shop.loopCurrency();
                    if (shop.hasCurrency()) {
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.split(Lang.CURRENCY_VALUE, "%url%", 0), TextColors.YELLOW, shop.getCurrency().getDisplayName(), TextColors.DARK_GREEN, Lang.split(Lang.CURRENCY_VALUE, "%url%", 1)}));
                        continue;
                    }
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.CURRENCY_SERVER}));
                }
            }
        }
    }
}

