/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.obnoxint.xnbt.XNBT;
import net.obnoxint.xnbt.types.CompoundTag;
import net.obnoxint.xnbt.types.NBTTag;
import net.obnoxint.xnbt.types.StringTag;
import org.spongepowered.api.Sponge;

public class WorldData {
    private String worldName;
    private File dataFile;
    private CompoundTag compoundTag;
    private boolean exists = false;

    public WorldData(String worldName) {
        this.worldName = worldName;
        String defaultWorld = Sponge.getServer().getDefaultWorldName();
        this.dataFile = defaultWorld.equalsIgnoreCase(worldName) ? new File(defaultWorld, "level.dat") : new File(defaultWorld + File.separator + worldName, "level.dat");
        if (this.dataFile.exists()) {
            this.exists = true;
            this.init();
        }
    }

    public WorldData(File directory) {
        this.dataFile = new File(directory, "level.dat");
        this.worldName = directory.getName();
        if (this.dataFile.exists()) {
            this.exists = true;
            this.init();
        }
    }

    public boolean exists() {
        return this.exists;
    }

    private void init() {
        try {
            for (NBTTag root : XNBT.loadTags(this.dataFile)) {
                CompoundTag compoundRoot = (CompoundTag)root;
                for (Map.Entry<String, NBTTag> rootItem : compoundRoot.entrySet()) {
                    if (!rootItem.getKey().equalsIgnoreCase("Data")) continue;
                    this.compoundTag = (CompoundTag)rootItem.getValue();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isCorrectLevelName() {
        for (Map.Entry<String, NBTTag> entry : this.compoundTag.entrySet()) {
            String levelName;
            if (!entry.getKey().equalsIgnoreCase("LevelName") || !(levelName = (String)entry.getValue().getPayload()).equalsIgnoreCase(this.worldName)) continue;
            return true;
        }
        return false;
    }

    public String getLevelName() {
        for (Map.Entry<String, NBTTag> entry : this.compoundTag.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("LevelName")) continue;
            return (String)entry.getValue().getPayload();
        }
        return null;
    }

    public void setLevelName(String name) throws IOException {
        this.compoundTag.put(new StringTag("LevelName", name));
        CompoundTag compoundRoot = new CompoundTag("", null);
        compoundRoot.put(this.compoundTag);
        ArrayList<NBTTag> list = new ArrayList<NBTTag>();
        list.add(compoundRoot);
        XNBT.saveTags(list, this.dataFile);
    }
}

