/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.core;

import com.mcsimonflash.sponge.cmdcontrol.CmdControl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;

public class CmdUtils {
    public static Text toText(String msg) {
        return TextSerializers.FORMATTING_CODE.deserialize(msg);
    }

    public static CommandResult execute(CommandSource src, String command, long delay) {
        if (delay > 0L) {
            Task.builder().execute(t -> Sponge.getCommandManager().process(src, command)).delay(delay, TimeUnit.MILLISECONDS).submit((Object)CmdControl.get());
            return CommandResult.queryResult((int)1);
        }
        return Sponge.getCommandManager().process(src, command);
    }

    public static Optional<URL> parseURL(String url) {
        try {
            return Optional.of(new URL(url));
        }
        catch (MalformedURLException ignored) {
            return Optional.empty();
        }
    }

    public static Text usage(String cmd, Text info, Text ... args) {
        return Text.builder((String)cmd).color(TextColors.GOLD).onClick((ClickAction)TextActions.suggestCommand((String)cmd)).onHover((HoverAction)TextActions.showText((Text)info)).append(new Text[]{Text.joinWith((Text)Text.of((String)" "), (Text[])args)}).build();
    }

    public static Text info(String name, String desc, String type, String aliases, String permission) {
        return Text.of((Object[])new Object[]{CmdUtils.desc(name, desc), CmdUtils.desc("Type", type), CmdUtils.desc("Aliases", aliases), CmdUtils.desc("Permission", permission)});
    }

    public static Text desc(String name, String desc) {
        return desc.isEmpty() ? Text.EMPTY : Text.of((Object[])new Object[]{name, TextColors.DARK_GRAY, ": ", TextColors.GRAY, desc});
    }

    public static Text arg(boolean req, String arg, Text info) {
        return Text.builder((String)((req ? "<" : "[") + arg + (req ? ">" : "]"))).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)info)).build();
    }

    public static Text link(String name, Optional<URL> optUrl) {
        return (Text)optUrl.map(u -> Text.builder((String)name).color(TextColors.WHITE).onClick((ClickAction)TextActions.openUrl((URL)u)).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{u}))).build()).orElseGet(() -> Text.builder((String)name).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Sorry! This URL is unavailable."))).build());
    }
}

