/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.computer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.compat.LuaHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.MultiblockComputerPeripheral;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public abstract class ComputerPeripheral {
    private final TileEntity _tile;
    private static Map<String, Map<String, ComputerMethod>> s_methodsNamesMap = Maps.newHashMap();
    private static Map<String, Map<Integer, ComputerMethod>> s_methodsIndexMap = Maps.newHashMap();
    private static Map<String, String[]> s_methodsNames = Maps.newHashMap();

    public ComputerPeripheral(@Nonnull TileEntity peripheral) {
        this._tile = peripheral;
    }

    @Nonnull
    public TileEntity getTileEntity() {
        return this._tile;
    }

    public abstract String getPeripheralStaticName();

    public abstract void populatePeripheralMethods(@Nonnull List<ComputerMethod> var1);

    public static Object[] help(@Nonnull MultiblockComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{"The help() method is not implemented yet"};
    }

    public static Object[] isMethodAvailable(@Nonnull MultiblockComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{null != peripheral.getMethod(LuaHelper.getStringFromArgs(arguments, 0))};
    }

    @Nonnull
    protected String[] getMethodsNames() {
        if (!s_methodsNames.containsKey(this.getPeripheralStaticName())) {
            this.buildMethodsMap();
        }
        return s_methodsNames.getOrDefault(this.getPeripheralStaticName(), new String[0]);
    }

    @Nullable
    protected ComputerMethod getMethod(@Nonnull String name) {
        if (!s_methodsNamesMap.containsKey(this.getPeripheralStaticName())) {
            this.buildMethodsMap();
        }
        Map<String, ComputerMethod> map = s_methodsNamesMap.get(this.getPeripheralStaticName());
        return map.getOrDefault(name, null);
    }

    @Nullable
    protected ComputerMethod getMethod(@Nonnull int index) {
        if (!s_methodsNamesMap.containsKey(this.getPeripheralStaticName())) {
            this.buildMethodsMap();
        }
        Map<Integer, ComputerMethod> map = s_methodsIndexMap.get(this.getPeripheralStaticName());
        return map.getOrDefault(index, null);
    }

    private void buildMethodsMap() {
        String peripheralName = this.getPeripheralStaticName();
        ArrayList methods = Lists.newArrayList();
        methods.add(new ComputerMethod<MultiblockComputerPeripheral>("help", ComputerPeripheral::help));
        methods.add(new ComputerMethod<MultiblockComputerPeripheral>("isMethodAvailable", ComputerPeripheral::isMethodAvailable));
        this.populatePeripheralMethods(methods);
        methods.sort(Comparator.comparing(ComputerMethod::getName));
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)methods.size());
        HashMap indexMap = Maps.newHashMapWithExpectedSize((int)methods.size());
        String[] names = new String[methods.size()];
        int index = 0;
        for (ComputerMethod method : methods) {
            if (null == method) continue;
            names[index] = method.getName();
            nameMap.put(names[index], method);
            indexMap.put(index, method);
            ++index;
        }
        s_methodsNamesMap.put(peripheralName, (Map<String, ComputerMethod>)ImmutableMap.copyOf((Map)nameMap));
        s_methodsIndexMap.put(peripheralName, (Map<Integer, ComputerMethod>)ImmutableMap.copyOf((Map)indexMap));
        s_methodsNames.put(peripheralName, names);
    }
}

