/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches;

import com.google.common.eventbus.Subscribe;
import com.therandomlabs.randompatches.client.TileEntityEndPortalRenderer;
import com.therandomlabs.randompatches.common.CommandRPReload;
import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.config.RPStaticConfig;
import com.therandomlabs.randompatches.core.RPTransformer;
import com.therandomlabs.randompatches.patch.EntityBoatPatch;
import com.therandomlabs.randompatches.patch.EntityPatch;
import com.therandomlabs.randompatches.patch.MinecartPatch;
import com.therandomlabs.randompatches.patch.NetHandlerLoginServerPatch;
import com.therandomlabs.randompatches.patch.NetHandlerPlayServerPatch;
import com.therandomlabs.randompatches.patch.ServerRecipeBookHelperPatch;
import com.therandomlabs.randompatches.patch.client.IngameMenuPatch;
import com.therandomlabs.randompatches.patch.client.ItemPotionPatch;
import com.therandomlabs.randompatches.patch.client.LanguageListPatch;
import com.therandomlabs.randompatches.patch.client.MinecraftPatch;
import com.therandomlabs.randompatches.patch.endportal.BlockEndPortalPatch;
import com.therandomlabs.randompatches.patch.endportal.BlockModelShapesPatch;
import com.therandomlabs.randompatches.patch.endportal.TileEntityEndPortalPatch;
import com.therandomlabs.randompatches.util.RPUtils;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RandomPatches {
    public static final String MOD_ID = "randompatches";
    public static final String NAME = "RandomPatches";
    public static final String VERSION = "1.12.2-1.11.0.3";
    public static final String MINECRAFT_VERSIONS = "[1.8,1.13)";
    public static final String CERTIFICATE_FINGERPRINT = "20d08fb3fe9c268a63a75d337fb507464c8aaccd";
    public static final int SORTING_INDEX = 2147473647;
    public static final boolean IS_DEOBFUSCATED = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final boolean IS_CLIENT = FMLLaunchHandler.side().isClient();
    public static final String MC_VERSION_STRING = (String)FMLInjectionData.data()[4];
    public static final int MC_VERSION = Integer.parseInt(MC_VERSION_STRING.split("\\.")[1]);
    public static final String DEFAULT_WINDOW_TITLE = "Minecraft " + MC_VERSION_STRING;
    public static final boolean SPONGEFORGE_INSTALLED = RPUtils.detect("org.spongepowered.mod.SpongeMod");
    public static final boolean ITLT_INSTALLED = RPUtils.detect("dk.zlepper.itlt.about.mod");
    public static final boolean REBIND_NARRATOR_INSTALLED = RPUtils.detect("quaternary.rebindnarrator.RebindNarrator");
    public static final boolean VANILLAFIX_INSTALLED = RPUtils.detect("org.dimdev.vanillafix.VanillaFix");
    public static final Logger LOGGER = LogManager.getLogger((String)"randompatches");

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        if (IS_CLIENT && MC_VERSION > 10) {
            RPConfig.reload();
        }
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (IS_CLIENT && RPStaticConfig.rpreloadclient) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandRPReload(Side.CLIENT));
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (!IS_CLIENT) {
            return;
        }
        if (MC_VERSION > 10) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        if (RPStaticConfig.isNarratorKeybindEnabled()) {
            MinecraftPatch.ToggleNarratorKeybind.register();
        }
    }

    @Subscribe
    public void serverStarting(FMLServerStartingEvent event) {
        if (RPStaticConfig.rpreload) {
            event.registerServerCommand((ICommand)new CommandRPReload(Side.SERVER));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            RPConfig.reload();
        }
    }

    public static void containerInit() {
        if (!RPUtils.hasFingerprint(RandomPatches.class, CERTIFICATE_FINGERPRINT)) {
            if (IS_DEOBFUSCATED) {
                LOGGER.debug("Invalid fingerprint detected!");
            } else {
                LOGGER.error("Invalid fingerprint detected!");
            }
        }
        if (RPStaticConfig.isEndPortalTweaksEnabled() && IS_CLIENT) {
            TileEntityEndPortalRenderer renderer = new TileEntityEndPortalRenderer();
            renderer.func_147497_a(TileEntityRendererDispatcher.field_147556_a);
            TileEntityRendererDispatcher.field_147556_a.field_147559_m.put(TileEntityEndPortal.class, renderer);
        }
        RPStaticConfig.setWindowSettings();
    }

    public static void registerPatches() {
        if (RPStaticConfig.patchLoginTimeout) {
            RPTransformer.register("net.minecraft.network.NetHandlerLoginServer", new NetHandlerLoginServerPatch());
        }
        if (RPStaticConfig.patchTitleScreenOnDisconnect) {
            RPTransformer.register("net.minecraft.client.gui.GuiIngameMenu", new IngameMenuPatch());
        }
        if (RPStaticConfig.patchNetHandlerPlayServer && MC_VERSION > 8) {
            RPTransformer.register("net.minecraft.network.NetHandlerPlayServer", new NetHandlerPlayServerPatch());
        }
        if (RPStaticConfig.fastLanguageSwitch && IS_CLIENT) {
            RPTransformer.register("net.minecraft.client.gui.GuiLanguage$List", new LanguageListPatch());
        }
        if (RPStaticConfig.patchMinecraftClass && IS_CLIENT) {
            RPTransformer.register("net.minecraft.client.Minecraft", new MinecraftPatch());
        }
        if (RPStaticConfig.minecartAIFix) {
            RPTransformer.register("net.minecraft.entity.item.EntityMinecart", new MinecartPatch());
        }
        if (RPStaticConfig.removePotionGlint && IS_CLIENT) {
            RPTransformer.register("net.minecraft.item.ItemPotion", new ItemPotionPatch());
        }
        if (RPStaticConfig.isEndPortalTweaksEnabled()) {
            RPTransformer.register("net.minecraft.block.BlockEndPortal", new BlockEndPortalPatch());
            RPTransformer.register("net.minecraft.client.renderer.BlockModelShapes", new BlockModelShapesPatch());
            RPTransformer.register("net.minecraft.tileentity.TileEntityEndPortal", new TileEntityEndPortalPatch());
        }
        if (RPStaticConfig.isRecipeBookNBTFixEnabled()) {
            RPTransformer.register("net.minecraft.util.ServerRecipeBookHelper", new ServerRecipeBookHelperPatch());
        }
        if (RPStaticConfig.patchEntityBoat && MC_VERSION > 8) {
            RPTransformer.register("net.minecraft.entity.item.EntityBoat", new EntityBoatPatch());
        }
        if (RPStaticConfig.mc2025Fix && MC_VERSION > 9) {
            RPTransformer.register("net.minecraft.entity.Entity", new EntityPatch());
        }
    }
}

