/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.itemfilter.ItemFilterTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class GuiItemFilter
extends GenericGuiContainer<ItemFilterTileEntity> {
    public static final int ITEMFILTER_WIDTH = 195;
    public static final int ITEMFILTER_HEIGHT = 212;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/itemfilter.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ImageChoiceLabel[] bits = new ImageChoiceLabel[54];

    public GuiItemFilter(ItemFilterTileEntity itemFilterTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)itemFilterTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "filter");
        this.field_146999_f = 195;
        this.field_147000_g = 212;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        int[] inputMode = ((ItemFilterTileEntity)this.tileEntity).getInputMode();
        int[] outputMode = ((ItemFilterTileEntity)this.tileEntity).getOutputMode();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            int side = direction.ordinal();
            int slot = 0;
            while (slot < 9) {
                ImageChoiceLabel choiceLabel;
                this.bits[side * 9 + slot] = choiceLabel = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(25 + slot * 18, 4 + side * 13, 12, 12))).addChoice("0", "Disabled", iconGuiElements, 160, 0).addChoice("1", "Input", iconGuiElements, 96, 16).addChoice("2", "Output", iconGuiElements, 80, 16);
                if ((inputMode[side] & 1 << slot) != 0) {
                    choiceLabel.setCurrentChoice(1);
                } else if ((outputMode[side] & 1 << slot) != 0) {
                    choiceLabel.setCurrentChoice(2);
                } else {
                    choiceLabel.setCurrentChoice(0);
                }
                int finalSlot = slot++;
                choiceLabel.addChoiceEvent((parent, newChoice) -> this.changeMode(side, finalSlot));
                toplevel.addChild((Widget)choiceLabel);
            }
        }
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
    }

    private void changeMode(int side, int slot) {
        ImageChoiceLabel choiceLabel = this.bits[side * 9 + slot];
        int c = choiceLabel.getCurrentChoiceIndex();
        boolean input = false;
        boolean output = false;
        if (c == 1) {
            input = true;
            output = false;
        } else if (c == 2) {
            input = false;
            output = true;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "itemfilter.setMode", TypedMap.builder().put(ItemFilterTileEntity.PARAM_SIDE, (Object)side).put(ItemFilterTileEntity.PARAM_SLOT, (Object)slot).put(ItemFilterTileEntity.PARAM_INPUT, (Object)input).put(ItemFilterTileEntity.PARAM_OUTPUT, (Object)output).build());
    }
}

