/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.dataservices.AbstractService;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class NameBanService
extends AbstractService<Map<String, String>> {
    public NameBanService(DataProvider<Map<String, String>> dataProvider) {
        super(dataProvider);
    }

    @Override
    protected String serviceName() {
        return "Name bans";
    }

    @Override
    public boolean load() {
        if (super.load()) {
            ArrayList toRemove = Lists.newArrayList();
            HashMap toAdd = Maps.newHashMap();
            ((Map)this.data).forEach((k, v) -> {
                String lower = k.toLowerCase();
                if (!k.equals(lower)) {
                    toRemove.add(k);
                    toAdd.put(lower, v);
                }
            });
            toRemove.forEach(((Map)this.data)::remove);
            ((Map)this.data).putAll(toAdd);
            return true;
        }
        return false;
    }

    public Optional<String> getBanReason(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name);
        return Optional.ofNullable(((Map)this.data).get(name.toLowerCase()));
    }

    public boolean removeBan(@Nonnull String name) {
        return ((Map)this.data).remove(name.toLowerCase()) != null;
    }

    public boolean setBan(@Nonnull String name, @Nonnull String reason) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)reason);
        Preconditions.checkArgument((!reason.isEmpty() ? 1 : 0) != 0);
        if (((Map)this.data).containsKey(name.toLowerCase())) {
            return false;
        }
        ((Map)this.data).put(name.toLowerCase(), reason);
        return true;
    }
}

