/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.command;

import io.github.nucleuspowered.nucleus.argumentparsers.GameProfileArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.NicknameArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.NucleusWorldPropertiesArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.SelectorArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.TimespanArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.UUIDArgument;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class NucleusParameters {
    public static final CommandElement ONE_TRUE_FALSE = GenericArguments.onlyOne((CommandElement)GenericArguments.bool((Text)Text.of((String)"true|false")));
    public static final CommandElement OPTIONAL_ONE_TRUE_FALSE = GenericArguments.optional((CommandElement)ONE_TRUE_FALSE);
    public static final CommandElement MANY_ENTITY = new SelectorArgument(new NicknameArgument((Text)Text.of((String)"subject"), NicknameArgument.Target.PLAYER), Entity.class);
    public static final CommandElement MANY_LIVING = new SelectorArgument(new NicknameArgument((Text)Text.of((String)"subject"), NicknameArgument.Target.PLAYER), Living.class);
    public static final CommandElement MANY_PLAYER_NO_SELECTOR = new NicknameArgument((Text)Text.of((String)"player"), NicknameArgument.Target.PLAYER);
    public static final CommandElement MANY_USER_NO_SELECTOR = new NicknameArgument((Text)Text.of((String)"user"), NicknameArgument.Target.USER);
    public static final CommandElement ONE_PLAYER_NO_SELECTOR = GenericArguments.onlyOne((CommandElement)MANY_PLAYER_NO_SELECTOR);
    public static final CommandElement MANY_PLAYER = new SelectorArgument(MANY_PLAYER_NO_SELECTOR, Player.class);
    public static final CommandElement ONE_PLAYER = GenericArguments.onlyOne((CommandElement)MANY_PLAYER);
    public static final CommandElement OPTIONAL_ONE_PLAYER = GenericArguments.optionalWeak((CommandElement)ONE_PLAYER);
    public static final CommandElement MANY_PLAYER_OR_CONSOLE = new SelectorArgument(new NicknameArgument((Text)Text.of((String)"player|-"), NicknameArgument.Target.PLAYER), Player.class);
    public static final CommandElement ONE_PLAYER_OR_CONSOLE = GenericArguments.onlyOne((CommandElement)MANY_PLAYER_OR_CONSOLE);
    public static final CommandElement ONE_USER = GenericArguments.onlyOne((CommandElement)new SelectorArgument(new NicknameArgument((Text)Text.of((String)"user"), NicknameArgument.Target.USER), Player.class));
    public static final CommandElement ONE_USER_PLAYER_KEY = GenericArguments.onlyOne((CommandElement)new SelectorArgument(new NicknameArgument((Text)Text.of((String)"player"), NicknameArgument.Target.USER), Player.class));
    public static final CommandElement ONE_USER_UUID = GenericArguments.onlyOne(UUIDArgument.user((Text)Text.of((String)"user uuid")));
    public static final CommandElement ONE_GAME_PROFILE_UUID = GenericArguments.onlyOne(UUIDArgument.gameProfile((Text)Text.of((String)"user uuid")));
    public static final CommandElement ONE_GAME_PROFILE = GenericArguments.onlyOne((CommandElement)new GameProfileArgument((Text)Text.of((String)"user")));
    public static final CommandElement COMMAND = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"command"));
    public static final CommandElement OPTIONAL_COMMAND = GenericArguments.optional((CommandElement)COMMAND);
    public static final CommandElement DESCRIPTION = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"description"));
    public static final CommandElement OPTIONAL_DESCRIPTION = GenericArguments.optional((CommandElement)DESCRIPTION);
    public static final CommandElement LORE = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"lore"));
    public static final CommandElement MESSAGE = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"message"));
    public static final CommandElement OPTIONAL_MESSAGE = GenericArguments.optional((CommandElement)MESSAGE);
    public static final CommandElement REASON = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"reason"));
    public static final CommandElement OPTIONAL_REASON = GenericArguments.optional((CommandElement)REASON);
    public static final CommandElement WORLD_PROPERTIES_ENABLED_ONLY = new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.ENABLED_ONLY);
    public static final CommandElement OPTIONAL_WEAK_WORLD_PROPERTIES_ENABLED_ONLY = GenericArguments.optionalWeak((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.ENABLED_ONLY));
    public static final CommandElement OPTIONAL_WORLD_PROPERTIES_ENABLED_ONLY = GenericArguments.optional((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.ENABLED_ONLY));
    public static final CommandElement WORLD_PROPERTIES_DISABLED_ONLY = new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.DISABLED_ONLY);
    public static final CommandElement WORLD_PROPERTIES_ALL = GenericArguments.onlyOne((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.ALL));
    public static final CommandElement OPTIONAL_WORLD_PROPERTIES_ALL = GenericArguments.optionalWeak((CommandElement)WORLD_PROPERTIES_ALL);
    public static final CommandElement WORLD_PROPERTIES_UNLOADED_ONLY = GenericArguments.onlyOne((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.UNLOADED_ONLY));
    public static final CommandElement WORLD_PROPERTIES_LOADED_ONLY = GenericArguments.onlyOne((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.LOADED_ONLY));
    public static final CommandElement DURATION = GenericArguments.onlyOne((CommandElement)new TimespanArgument((Text)Text.of((String)"duration")));
    public static final CommandElement OPTIONAL_DURATION = GenericArguments.optional((CommandElement)DURATION);
    public static final CommandElement OPTIONAL_WEAK_DURATION = GenericArguments.optionalWeak((CommandElement)DURATION);
    public static final CommandElement POSITION = GenericArguments.onlyOne((CommandElement)GenericArguments.vector3d((Text)Text.of((String)"x y z")));
    public static final CommandElement LOCATION = GenericArguments.onlyOne((CommandElement)GenericArguments.location((Text)Text.of((String)"location")));
    public static final CommandElement OPTIONAL_LOCATION = GenericArguments.optional((CommandElement)LOCATION);

    private NucleusParameters() {
    }

    public static class Keys {
        public static final String BOOL = "true|false";
        public static final String COMMAND = "command";
        public static final String DESCRIPTION = "description";
        public static final String DURATION = "duration";
        public static final String LOCATION = "location";
        public static final String LORE = "lore";
        public static final String MESSAGE = "message";
        public static final String PLAYER = "player";
        public static final String PLAYER_OR_CONSOLE = "player|-";
        public static final String REASON = "reason";
        public static final String SUBJECT = "subject";
        public static final String USER = "user";
        public static final String USER_UUID = "user uuid";
        public static final String WORLD = "world";
        public static final String XYZ = "x y z";

        private Keys() {
        }
    }
}

