/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.services;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarmupManagerService;
import io.github.nucleuspowered.nucleus.internal.interfaces.CancellableTask;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;

public class WarmupManager
implements NucleusWarmupManagerService {
    private final Object mapLock = new Object();
    @GuardedBy(value="mapLock")
    private final Map<UUID, Task> warmupTasks = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWarmup(UUID player, Task task) {
        Task t;
        Object object = this.mapLock;
        synchronized (object) {
            t = this.warmupTasks.put(player, task);
        }
        if (t != null) {
            t.cancel();
            Consumer ct = t.getConsumer();
            if (ct instanceof CancellableTask) {
                ((CancellableTask)ct).onCancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWarmup(UUID player) {
        if (this.warmupTasks.containsKey(player)) {
            Task t;
            Object object = this.mapLock;
            synchronized (object) {
                t = this.warmupTasks.remove(player);
            }
            if (t != null && t.cancel()) {
                if (t.getConsumer() instanceof CancellableTask) {
                    ((CancellableTask)t.getConsumer()).onCancel();
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Object object = this.mapLock;
        synchronized (object) {
            this.warmupTasks.entrySet().stream().filter(v -> !Sponge.getGame().getScheduler().getScheduledTasks().contains(v.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(this.warmupTasks::remove);
        }
    }
}

