/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.afk.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.ServiceChangeListener;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RegisterCommand(value={"afk", "away"})
@Permissions(suggestedLevel=SuggestedLevel.USER)
@NoModifiers
@RunAsync
@EssentialsEquivalent(value={"afk", "away"})
@NonnullByDefault
public class AFKCommand
extends AbstractCommand<Player> {
    private final AFKHandler afkHandler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(AFKHandler.class);
    static final String KICK_EXEMPT_SUFFIX = "exempt.kick";

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("exempt.toggle", PermissionInformation.getWithTranslation("permission.afk.exempt.toggle", SuggestedLevel.NONE));
        m.put(KICK_EXEMPT_SUFFIX, PermissionInformation.getWithTranslation("permission.afk.exempt.kick", SuggestedLevel.ADMIN));
        m.put("notify", PermissionInformation.getWithTranslation("permission.afk.notify", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        if (!ServiceChangeListener.isOpOnly() && this.permissions.testSuffix((Subject)src, "exempt.toggle")) {
            throw ReturnMessageException.fromKey("command.afk.exempt", new Object[0]);
        }
        boolean isAFK = this.afkHandler.isAFK(src);
        if (isAFK) {
            this.afkHandler.stageUserActivityUpdate(src);
        } else if (!this.afkHandler.setAfkInternal(src, CauseStackHelper.createCause(src), true)) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.afk.notset", new String[0]));
        }
        return CommandResult.success();
    }
}

