/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.service.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoCommandPrefix;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.userprefs.PreferenceKey;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@Permissions(mainOverride="userprefs", supportsOthers=true, suggestedLevel=SuggestedLevel.USER)
@NoModifiers
@RegisterCommand(value={"nuserprefs", "userprefs"})
@NoCommandPrefix
@NonnullByDefault
public class NucleusUserPrefsCommand
extends AbstractCommand.SimpleTargetOtherUser {
    private static final Text SEPARATOR = Text.of((String)": ");

    @Override
    protected CommandElement[] additionalArguments() {
        return new CommandElement[]{GenericArguments.optional((CommandElement)((UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class)).getElement())};
    }

    @Override
    protected CommandResult executeWithPlayer(CommandSource source, User target, CommandContext args, boolean isSelf) throws Exception {
        if (args.hasAny(UserPreferenceService.PREFERENCE_ARG)) {
            if (args.hasAny(UserPreferenceService.VALUE_ARG)) {
                return this.set(source, target, isSelf, (PreferenceKey)args.requireOne(UserPreferenceService.PREFERENCE_ARG), args.requireOne(UserPreferenceService.VALUE_ARG));
            }
            return this.get(source, target, (PreferenceKey)args.requireOne(UserPreferenceService.PREFERENCE_ARG));
        }
        return this.list(source, target);
    }

    private <T> CommandResult set(CommandSource source, User target, boolean isSelf, PreferenceKey<T> key, @Nullable Object value) {
        UserPreferenceService service = (UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class);
        service.set(target.getUniqueId(), key, key.getValueClass().cast(value));
        if (isSelf) {
            this.sendMessageTo(source, "command.userprefs.set.self", new String[]{key.getID(), String.valueOf(value)});
        } else {
            this.sendMessageTo(source, "command.userprefs.set.other", new Object[]{target, key.getID(), String.valueOf(value)});
        }
        return CommandResult.success();
    }

    private <T> CommandResult get(CommandSource source, User target, PreferenceKey<T> key) {
        UserPreferenceService service = (UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class);
        source.sendMessage(this.get(source, key, service.get(target.getUniqueId(), key).orElse(null)));
        return CommandResult.success();
    }

    private CommandResult list(CommandSource source, User target) {
        UserPreferenceService service = (UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class);
        Map<NucleusUserPreferenceService.PreferenceKey<?>, Object> ret = service.get(target);
        ArrayList entry = new ArrayList();
        ret.forEach((key, value) -> entry.add(this.get(source, (NucleusUserPreferenceService.PreferenceKey<?>)key, value)));
        Util.getPaginationBuilder(source).title(this.getMessageFor(source, "command.userprefs.title", new String[]{target.getName()})).contents(entry).build().sendTo((MessageReceiver)source);
        return CommandResult.success();
    }

    private Text get(CommandSource source, NucleusUserPreferenceService.PreferenceKey<?> key, @Nullable Object value) {
        LiteralText.Builder tb = Text.builder((String)key.getID().replaceAll("^nucleus:", ""));
        tb.append(new Text[]{SEPARATOR});
        Text result = value == null ? this.getMessageFor(source, "standard.unset") : (value instanceof Boolean ? this.getMessageFor(source, "standard." + (Boolean)value) : Text.of((Object[])new Object[]{value}));
        tb.append(new Text[]{result});
        if (key.getDescription() != null && !key.getDescription().isEmpty()) {
            tb.onHover((HoverAction)TextActions.showText((Text)(key instanceof PreferenceKey ? this.getMessageFor(source, ((PreferenceKey)key).getDescriptionKey()) : Text.of((String)key.getDescription()))));
        }
        return tb.build();
    }
}

