/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(supportsOthers=true)
@NonnullByDefault
@RegisterCommand(value={"lightning", "strike", "smite", "thor", "shock"})
@EssentialsEquivalent(value={"lightning", "strike", "smite", "thor", "shock"}, isExact=false, notes="Selectors can be used, entities can be struck.")
public class LightningCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optional((CommandElement)this.requirePermissionArg(NucleusParameters.MANY_LIVING, this.permissions.getPermissionWithSuffix("others")))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Collection playerCollection = args.getAll("subject");
        if (playerCollection.isEmpty()) {
            if (!(src instanceof Player)) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.playeronly", new String[0]));
                return CommandResult.empty();
            }
            Player pl = (Player)src;
            BlockRay playerBlockRay = BlockRay.from((Entity)pl).distanceLimit(100.0).stopFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1)).build();
            Optional obh = playerBlockRay.end();
            Location lightningLocation = obh.map(BlockRayHit::getLocation).orElseGet(() -> pl.getLocation().add(0.0, 3.0, 0.0));
            return this.spawnLightning((Location<World>)lightningLocation, src, null);
        }
        int successCount = 0;
        for (Living pl : playerCollection) {
            CommandResult cr = this.spawnLightning((Location<World>)pl.getLocation(), src, pl instanceof Player ? (Player)pl : null);
            successCount += cr.getSuccessCount().orElse(0).intValue();
        }
        return CommandResult.builder().successCount(Integer.valueOf(successCount)).build();
    }

    private CommandResult spawnLightning(Location<World> location, CommandSource src, @Nullable Player target) throws ReturnMessageException {
        World world = (World)location.getExtent();
        Entity bolt = world.createEntity(EntityTypes.LIGHTNING, location.getPosition());
        if (CauseStackHelper.createFrameWithCausesWithReturn(c -> world.spawnEntity(bolt), src).booleanValue()) {
            if (target != null) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.lightning.success.other", Nucleus.getNucleus().getNameUtil().getName((User)target)));
            }
            return CommandResult.success();
        }
        if (target != null) {
            throw ReturnMessageException.fromKey("command.lightning.errorplayer", Nucleus.getNucleus().getNameUtil().getName((User)target));
        }
        throw ReturnMessageException.fromKey("command.lightning.error", new Object[0]);
    }
}

