/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.LocationData;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.jail.JailParameters;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfig;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Permissions(suggestedLevel=SuggestedLevel.MOD, supportsSelectors=true)
@NoModifiers
@RegisterCommand(value={"jail", "unjail", "togglejail"})
@EssentialsEquivalent(value={"togglejail", "tjail", "unjail", "jail"})
public class JailCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final JailHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JailHandler.class);
    private boolean requireUnjailPermission = false;

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("unjail", PermissionInformation.getWithTranslation("permission.jail.unjail", SuggestedLevel.MOD));
        m.put("notify", PermissionInformation.getWithTranslation("permission.jail.notify", SuggestedLevel.MOD));
        m.put("offline", PermissionInformation.getWithTranslation("permission.jail.offline", SuggestedLevel.MOD));
        m.put("teleportjailed", PermissionInformation.getWithTranslation("permission.jail.teleportjailed", SuggestedLevel.ADMIN));
        m.put("teleporttojailed", PermissionInformation.getWithTranslation("permission.jail.teleporttojailed", SuggestedLevel.ADMIN));
        m.put("exempt.target", PermissionInformation.getWithTranslation("permission.jail.exempt.target", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.ONE_USER, JailParameters.OPTIONAL_JAIL, NucleusParameters.OPTIONAL_WEAK_DURATION, NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        User pl = (User)args.getOne("user").get();
        if (!pl.isOnline() && !this.permissions.testSuffix((Subject)src, "offline")) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jail.offline.noperms", new String[0]));
            return CommandResult.empty();
        }
        if (this.handler.isPlayerJailed(pl)) {
            if (!this.requireUnjailPermission || this.permissions.testSuffix((Subject)src, "unjail")) {
                return this.onUnjail(src, args, pl);
            }
            throw ReturnMessageException.fromKey("command.jail.unjail.perm", new Object[0]);
        }
        if (this.permissions.testSuffix((Subject)pl, "exempt.target", src, false)) {
            throw ReturnMessageException.fromKey("command.jail.exempt", pl.getName());
        }
        return this.onJail(src, args, pl);
    }

    private CommandResult onUnjail(CommandSource src, CommandContext args, User user) throws ReturnMessageException {
        if (CauseStackHelper.createFrameWithCausesWithReturn(c -> this.handler.unjailPlayer(user), src).booleanValue()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jail.unjail.success", user.getName()));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.jail.unjail.fail", user.getName());
    }

    private CommandResult onJail(CommandSource src, CommandContext args, User user) throws ReturnMessageException {
        Text messageTo;
        Text message;
        JailData jd;
        Optional owl = args.getOne("jail");
        if (!owl.isPresent()) {
            throw ReturnMessageException.fromKey("command.jail.jail.nojail", new Object[0]);
        }
        Optional duration = args.getOne("duration");
        String reason = args.getOne("reason").orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.jail.reason", new String[0]));
        if (duration.isPresent()) {
            jd = user.isOnline() ? new JailData(Util.getUUID(src), ((LocationData)owl.get()).getName(), reason, (Location<World>)((Player)user.getPlayer().get()).getLocation(), Instant.now().plusSeconds((Long)duration.get())) : new JailData(Util.getUUID(src), ((LocationData)owl.get()).getName(), reason, null, Duration.of((Long)duration.get(), ChronoUnit.SECONDS));
            message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkjail.jailedfor", user.getName(), jd.getJailName(), src.getName(), Util.getTimeStringFromSeconds((Long)duration.get()));
            messageTo = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jail.jailedfor", ((LocationData)owl.get()).getName(), src.getName(), Util.getTimeStringFromSeconds((Long)duration.get()));
        } else {
            jd = new JailData(Util.getUUID(src), ((LocationData)owl.get()).getName(), reason, (Location<World>)((Location)user.getPlayer().map(Locatable::getLocation).orElse(null)));
            message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkjail.jailedperm", user.getName(), ((LocationData)owl.get()).getName(), src.getName());
            messageTo = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jail.jailedperm", ((LocationData)owl.get()).getName(), src.getName());
        }
        if (this.handler.jailPlayer(user, jd)) {
            MutableMessageChannel mc = new PermissionMessageChannel(this.permissions.getPermissionWithSuffix("notify")).asMutable();
            mc.addMember((MessageReceiver)src);
            mc.send(message);
            mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", reason));
            user.getPlayer().ifPresent(x -> {
                x.sendMessage(messageTo);
                x.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", reason));
            });
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.jail.error", new Object[0]);
    }

    @Override
    public void onReload() {
        this.requireUnjailPermission = ((JailConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JailConfigAdapter.class).getNodeOrDefault()).isRequireUnjailPermission();
    }
}

