/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NoModifiers
@NonnullByDefault
@RunAsync
@RegisterCommand(value={"jails"})
@Permissions(prefix="jail", mainOverride="list", suggestedLevel=SuggestedLevel.MOD)
@EssentialsEquivalent(value={"jails"})
public class JailsCommand
extends AbstractCommand<CommandSource> {
    private final JailHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JailHandler.class);

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        Map<String, NamedLocation> mjs = this.handler.getJails();
        if (mjs.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jails.nojails", new String[0]));
            return CommandResult.empty();
        }
        List lt = mjs.entrySet().stream().map(x -> this.createJail((NamedLocation)x.getValue(), (String)x.getKey())).collect(Collectors.toList());
        Util.getPaginationBuilder(src).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jails.list.header", new String[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text createJail(@Nullable NamedLocation data, String name) {
        if (data == null || !data.getLocation().isPresent()) {
            return Text.builder((String)name).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jails.unavailable", new String[0]))).build();
        }
        Location<World> world = data.getLocation().get();
        LiteralText.Builder inner = Text.builder((String)name).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onClick((ClickAction)TextActions.runCommand((String)("/jails tp " + name))).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jails.warpprompt", name)));
        return Text.builder().append(new Text[]{inner.build()}).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.warploc", ((World)world.getExtent()).getName(), world.getBlockPosition().toString())}).build();
    }
}

