/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfig;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.datamodules.JailUserDataModule;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class LogoutJailListener
implements ListenerBase.Conditional {
    @Listener
    public void onLogout(ClientConnectionEvent.Disconnect event, @Getter(value="getTargetEntity") Player player) {
        Nucleus.getNucleus().getUserDataManager().get((User)player).ifPresent(mus -> {
            Optional<JailData> ojd = mus.get(JailUserDataModule.class).getJailData();
            ojd.ifPresent(jailData -> {
                Optional<Instant> end = jailData.getEndTimestamp();
                end.ifPresent(instant -> jailData.setTimeFromNextLogin(Duration.between(Instant.now(), instant)));
                mus.get(JailUserDataModule.class).setJailData((JailData)jailData);
            });
        });
    }

    @Override
    public boolean shouldEnable() {
        return Nucleus.getNucleus().getConfigValue("jail", JailConfigAdapter.class, JailConfig::isJailOnlineOnly).orElse(false);
    }
}

