/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.KitArgument;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitHandler;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

public abstract class KitFallbackBase<T extends CommandSource>
extends AbstractCommand<T> {
    private ImmutableList<String> aliasesForKits = ImmutableList.of();
    protected static final String KIT_PARAMETER_KEY = "kit";
    protected static final CommandElement KIT_PARAMETER_PERM_CHECK = GenericArguments.onlyOne((CommandElement)new KitArgument((Text)Text.of((String)"kit"), true));
    protected static final CommandElement KIT_PARAMETER_NO_PERM_CHECK = GenericArguments.onlyOne((CommandElement)new KitArgument((Text)Text.of((String)"kit"), false));
    protected static final KitHandler KIT_HANDLER = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(KitHandler.class);

    @Override
    protected void afterPostInit() {
        super.afterPostInit();
        this.aliasesForKits = ImmutableList.copyOf((Object[])this.getAliases());
    }

    @Override
    @NonnullByDefault
    protected boolean allowFallback(CommandSource source, CommandArgs args, CommandContext context) {
        if (context.hasAny(KIT_PARAMETER_KEY) || this.aliasesForKits.stream().noneMatch(x -> KIT_HANDLER.exists((String)x, true))) {
            return false;
        }
        return super.allowFallback(source, args, context);
    }
}

