/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.service.NucleusPrivateMessagingService;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.message.MessageUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.message.commands.MessageCommand;
import io.github.nucleuspowered.nucleus.modules.message.commands.MsgToggleCommand;
import io.github.nucleuspowered.nucleus.modules.message.commands.SocialSpyCommand;
import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfig;
import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.message.events.InternalNucleusMessageEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@APIService(value=NucleusPrivateMessagingService.class)
public class MessageHandler
implements NucleusPrivateMessagingService,
Reloadable,
PermissionTrait,
ServiceBase {
    private final MessageConfigAdapter mca;
    private final UserDataManager ucl;
    private final TextParsingUtils textParsingUtils;
    private MessageConfig messageConfig;
    private boolean useLevels = false;
    private boolean sameLevel = false;
    private int serverLevel = 0;
    private final CommandPermissionHandler messagepermissions;
    private final CommandPermissionHandler socialspypermissions;
    private final Map<String[], Function<String, String>> replacements = this.createReplacements();
    private final Map<UUID, UUID> messagesReceived = Maps.newHashMap();
    private final Map<UUID, CustomMessageTarget<? extends CommandSource>> targets = Maps.newHashMap();
    private final Map<String, UUID> targetNames = Maps.newHashMap();
    private final String msgToggleBypass = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(MsgToggleCommand.class).getPermissionWithSuffix("bypass");
    private final UserPreferenceService userPreferenceService = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(UserPreferenceService.class);
    public static final String socialSpyOption = "nucleus.socialspy.level";

    public MessageHandler() throws Exception {
        Nucleus nucleus = Nucleus.getNucleus();
        this.textParsingUtils = nucleus.getTextParsingUtils();
        this.ucl = nucleus.getUserDataManager();
        this.mca = nucleus.getModuleContainer().getConfigAdapterForModule("message", MessageConfigAdapter.class);
        this.messagepermissions = nucleus.getPermissionRegistry().getPermissionsForNucleusCommand(MessageCommand.class);
        this.socialspypermissions = nucleus.getPermissionRegistry().getPermissionsForNucleusCommand(SocialSpyCommand.class);
        this.onReload();
    }

    @Override
    public void onReload() {
        this.messageConfig = (MessageConfig)this.mca.getNodeOrDefault();
        this.useLevels = this.messageConfig.isSocialSpyLevels();
        this.sameLevel = this.messageConfig.isSocialSpySameLevel();
        this.serverLevel = this.messageConfig.getServerLevel();
    }

    @Override
    public boolean isSocialSpy(User user) {
        Tristate ts = this.forcedSocialSpyState(user);
        if (ts == Tristate.UNDEFINED) {
            return this.userPreferenceService.getUnwrapped(user.getUniqueId(), MessageUserPrefKeys.SOCIAL_SPY);
        }
        return ts.asBoolean();
    }

    @Override
    public boolean isUsingSocialSpyLevels() {
        return this.useLevels;
    }

    @Override
    public boolean canSpySameLevel() {
        return this.sameLevel;
    }

    @Override
    public int getCustomTargetLevel() {
        return this.messageConfig.getCustomTargetLevel();
    }

    @Override
    public int getServerLevel() {
        return this.serverLevel;
    }

    @Override
    public int getSocialSpyLevel(User user) {
        return this.useLevels ? Util.getPositiveIntOptionFromSubject((Subject)user, socialSpyOption).orElse(0) : 0;
    }

    @Override
    public Tristate forcedSocialSpyState(User user) {
        if (this.socialspypermissions.testSuffix((Subject)user, "base")) {
            if (this.messageConfig.isSocialSpyAllowForced() && this.socialspypermissions.testSuffix((Subject)user, "force")) {
                return Tristate.TRUE;
            }
            return Tristate.UNDEFINED;
        }
        return Tristate.FALSE;
    }

    @Override
    public boolean setSocialSpy(User user, boolean isSocialSpy) {
        if (this.forcedSocialSpyState(user) != Tristate.UNDEFINED) {
            return false;
        }
        this.userPreferenceService.set(user.getUniqueId(), MessageUserPrefKeys.SOCIAL_SPY, isSocialSpy);
        return true;
    }

    @Override
    public boolean canSpyOn(User spyingUser, CommandSource ... sourceToSpyOn) throws IllegalArgumentException {
        if (sourceToSpyOn.length == 0) {
            throw new IllegalArgumentException("sourceToSpyOn must have at least one CommandSource");
        }
        if (this.isSocialSpy(spyingUser)) {
            if (Arrays.stream(sourceToSpyOn).anyMatch(x -> x instanceof User && spyingUser.getUniqueId().equals(((User)x).getUniqueId()))) {
                return false;
            }
            if (this.useLevels) {
                int target = Arrays.stream(sourceToSpyOn).mapToInt(this::getSocialSpyLevelForSource).max().orElse(0);
                if (this.sameLevel) {
                    return target <= this.getSocialSpyLevel(spyingUser);
                }
                return target < this.getSocialSpyLevel(spyingUser);
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<CommandSource> onlinePlayersCanSpyOn(boolean includeConsole, CommandSource ... sourceToSpyOn) throws IllegalArgumentException {
        if (sourceToSpyOn.length == 0) {
            throw new IllegalArgumentException("sourceToSpyOn must have at least one CommandSource");
        }
        List<CommandSource> toSpyOn = Arrays.asList(sourceToSpyOn);
        Set uuidsToSpyOn = toSpyOn.stream().map(x -> x instanceof User ? ((User)x).getUniqueId() : Util.consoleFakeUUID).collect(Collectors.toSet());
        Set<Object> sources = Sponge.getServer().getOnlinePlayers().stream().filter(x -> !uuidsToSpyOn.contains(x.getUniqueId())).filter(this::isSocialSpy).collect(Collectors.toSet());
        if (!this.useLevels) {
            if (includeConsole) {
                sources.add((CommandSource)Sponge.getServer().getConsole());
            }
            return sources;
        }
        int highestLevel = toSpyOn.stream().mapToInt(this::getSocialSpyLevelForSource).max().orElse(0);
        sources = sources.stream().filter(x -> this.sameLevel ? this.getSocialSpyLevelForSource((CommandSource)x) >= highestLevel : this.getSocialSpyLevelForSource((CommandSource)x) > highestLevel).collect(Collectors.toSet());
        if (includeConsole) {
            sources.add((CommandSource)Sponge.getServer().getConsole());
        }
        return sources;
    }

    @Override
    public boolean sendMessage(CommandSource sender, CommandSource receiver, String message) {
        Set<CommandSource> lm;
        MessageChannel mc;
        boolean isBlocked = false;
        boolean isCancelled = Sponge.getEventManager().post((Event)new InternalNucleusMessageEvent(sender, receiver, message));
        if (isCancelled) {
            sender.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("message.cancel", new String[0]));
            if (!this.messageConfig.isShowMessagesInSocialSpyWhileMuted()) {
                return false;
            }
        }
        UserPreferenceService userPreferenceService = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(UserPreferenceService.class);
        if (receiver instanceof Player && !this.hasPermission((Subject)sender, this.msgToggleBypass) && !userPreferenceService.getUnwrapped(((Player)receiver).getUniqueId(), MessageUserPrefKeys.RECEIVING_MESSAGES).booleanValue()) {
            isCancelled = true;
            isBlocked = true;
            sender.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("message.blocked", Nucleus.getNucleus().getNameUtil().getName((User)((Player)receiver))));
            if (!this.messageConfig.isShowMessagesInSocialSpyWhileMuted()) {
                return false;
            }
        }
        UUID uuidSender = this.getUUID(sender);
        UUID uuidReceiver = this.getUUID(receiver);
        HashMap variables = Maps.newHashMap();
        variables.put("from", sender);
        variables.put("to", receiver);
        HashMap tokens = Maps.newHashMap();
        tokens.put("from", cs -> this.getNameFromCommandSource(sender, this.textParsingUtils::addCommandToName));
        tokens.put("to", cs -> this.getNameFromCommandSource(receiver, this.textParsingUtils::addCommandToName));
        tokens.put("fromdisplay", cs -> this.getNameFromCommandSource(sender, this.textParsingUtils::addCommandToDisplayName));
        tokens.put("todisplay", cs -> this.getNameFromCommandSource(receiver, this.textParsingUtils::addCommandToDisplayName));
        Text tm = this.useMessage(sender, message);
        if (!isCancelled) {
            sender.sendMessage(this.constructMessage(sender, tm, this.messageConfig.getMessageSenderPrefix(), tokens, variables));
            receiver.sendMessage(this.constructMessage(sender, tm, this.messageConfig.getMessageReceiverPrefix(), tokens, variables));
        }
        NucleusTextTemplateImpl prefix = this.messageConfig.getMessageSocialSpyPrefix();
        if (isBlocked) {
            prefix = NucleusTextTemplateFactory.createFromAmpersandString(this.messageConfig.getBlockedTag() + prefix.getRepresentation());
        }
        if (isCancelled) {
            prefix = NucleusTextTemplateFactory.createFromAmpersandString(this.messageConfig.getMutedTag() + prefix.getRepresentation());
        }
        MessageConfig.Targets targets = this.messageConfig.spyOn();
        if ((sender instanceof Player && targets.isPlayer() || sender instanceof ConsoleSource && targets.isCustom() || targets.isCustom()) && !(mc = MessageChannel.fixed(lm = this.onlinePlayersCanSpyOn(!uuidSender.equals(Util.consoleFakeUUID) && !uuidReceiver.equals(Util.consoleFakeUUID), sender, receiver))).getMembers().isEmpty()) {
            mc.send(this.constructMessage(sender, tm, prefix, tokens, variables));
        }
        if (!isCancelled) {
            this.messagesReceived.put(uuidReceiver, uuidSender);
        }
        return !isCancelled;
    }

    private Optional<Text> getNameFromCommandSource(CommandSource source, Function<CommandSource, Text> standardFn) {
        CustomMessageTarget<? extends CommandSource> target;
        if (source instanceof Identifiable && (target = this.targets.get(((Identifiable)source).getUniqueId())) != null) {
            return Optional.of(((CustomMessageTarget)target).getDisplayName());
        }
        return Optional.of(standardFn.apply(source));
    }

    public boolean replyMessage(CommandSource sender, String message) {
        Optional<CommandSource> cs = this.getLastMessageFrom(this.getUUID(sender));
        if (cs.isPresent()) {
            return this.sendMessage(sender, cs.get(), message);
        }
        sender.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("message.noreply", new String[0]));
        return false;
    }

    @Override
    public Optional<CommandSource> getConsoleReplyTo() {
        return this.getLastMessageFrom(Util.consoleFakeUUID);
    }

    @Override
    public Optional<CommandSource> getReplyTo(User user) {
        return this.getLastMessageFrom(user.getUniqueId());
    }

    @Override
    public <T extends CommandSource & Identifiable> Optional<CommandSource> getCommandSourceReplyTo(T from) {
        return this.getLastMessageFrom(((Identifiable)from).getUniqueId());
    }

    @Override
    public void setReplyTo(User user, CommandSource toReplyTo) {
        this.messagesReceived.put(user.getUniqueId(), this.getUUID((CommandSource)Preconditions.checkNotNull((Object)toReplyTo)));
    }

    @Override
    public void setConsoleReplyTo(CommandSource toReplyTo) {
        this.messagesReceived.put(Util.consoleFakeUUID, this.getUUID((CommandSource)Preconditions.checkNotNull((Object)toReplyTo)));
    }

    @Override
    public <T extends CommandSource & Identifiable> void setCommandSourceReplyTo(T source, CommandSource replyTo) {
        this.messagesReceived.put(((Identifiable)source).getUniqueId(), this.getUUID(replyTo));
    }

    @Override
    public void clearReplyTo(User user) {
        this.messagesReceived.remove(user.getUniqueId());
    }

    @Override
    public <T extends CommandSource & Identifiable> void clearCommandSourceReplyTo(T user) {
        this.messagesReceived.remove(((Identifiable)user).getUniqueId());
    }

    @Override
    public void clearConsoleReplyTo() {
        this.messagesReceived.remove(Util.consoleFakeUUID);
    }

    @Override
    public <T extends CommandSource & Identifiable> void registerMessageTarget(UUID uniqueId, String targetName, @Nullable Text displayName, Supplier<T> target) {
        Preconditions.checkNotNull((Object)uniqueId);
        Preconditions.checkNotNull((Object)targetName);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument((!uniqueId.equals(Util.consoleFakeUUID) ? 1 : 0) != 0, (Object)"Cannot use the zero UUID");
        Preconditions.checkArgument((boolean)targetName.toLowerCase().matches("[a-z0-9_-]{3,}"), (Object)"Target name must only contain letters, numbers, hyphens and underscores. and must be at least three characters long.");
        Preconditions.checkState((!this.targets.containsKey(uniqueId) ? 1 : 0) != 0, (Object)"UUID already registered");
        Preconditions.checkState((!this.targetNames.containsKey(targetName.toLowerCase()) ? 1 : 0) != 0, (Object)"Target name already registered.");
        this.targets.put(uniqueId, new CustomMessageTarget(uniqueId, targetName, displayName, target));
        this.targetNames.put(targetName.toLowerCase(), uniqueId);
    }

    public Optional<CommandSource> getLastMessageFrom(UUID from) {
        Optional om;
        Preconditions.checkNotNull((Object)from);
        UUID to = this.messagesReceived.get(from);
        if (to == null) {
            return Optional.empty();
        }
        if (to.equals(Util.consoleFakeUUID)) {
            return Optional.of(Sponge.getServer().getConsole());
        }
        if (this.targets.containsKey(to) && (om = ((CustomMessageTarget)this.targets.get(to)).get()).isPresent()) {
            return om.map(x -> x);
        }
        return Sponge.getServer().getOnlinePlayers().stream().filter(x -> x.getUniqueId().equals(to)).map(y -> y).findFirst();
    }

    public Optional<CommandSource> getTarget(String target) {
        CustomMessageTarget<? extends CommandSource> cmt;
        UUID u = this.targetNames.get(target.toLowerCase());
        if (u != null && (cmt = this.targets.get(u)) != null) {
            return ((CustomMessageTarget)cmt).get().map(x -> x);
        }
        return Optional.empty();
    }

    public ImmutableMap<String, UUID> getTargetNames() {
        return ImmutableMap.copyOf(this.targetNames);
    }

    private UUID getUUID(CommandSource sender) {
        return sender instanceof Identifiable ? ((Identifiable)sender).getUniqueId() : Util.consoleFakeUUID;
    }

    private Text constructMessage(CommandSource sender, Text message, NucleusTextTemplateImpl template, Map<String, Function<CommandSource, Optional<Text>>> tokens, Map<String, Object> variables) {
        return TextParsingUtils.joinTextsWithColoursFlowing(template.getForCommandSource(sender, tokens, variables), message);
    }

    private Map<String[], Function<String, String>> createReplacements() {
        HashMap<String[], Function<String, String>> t = new HashMap<String[], Function<String, String>>();
        t.put(new String[]{"colour", "color"}, s -> s.replaceAll("&[0-9a-fA-F]", ""));
        t.put(new String[]{"style"}, s -> s.replaceAll("&[l-oL-O]", ""));
        t.put(new String[]{"magic"}, s -> s.replaceAll("&[kK]", ""));
        return t;
    }

    private Text useMessage(CommandSource player, String m) {
        for (Map.Entry<String[], Function<String, String>> r : this.replacements.entrySet()) {
            if (!Arrays.stream((Object[])r.getKey()).noneMatch(x -> this.messagepermissions.testSuffix((Subject)player, (String)x))) continue;
            m = r.getValue().apply(m);
        }
        Text result = this.messagepermissions.testSuffix((Subject)player, "url") ? TextParsingUtils.addUrls(m) : TextSerializers.FORMATTING_CODE.deserialize(m);
        return result;
    }

    private int getSocialSpyLevelForSource(CommandSource source) {
        if (this.useLevels) {
            if (source instanceof User) {
                return this.getSocialSpyLevel((User)source);
            }
            if (source instanceof Identifiable && this.targets.containsKey(((Identifiable)source).getUniqueId())) {
                return this.messageConfig.getCustomTargetLevel();
            }
            return this.messageConfig.getServerLevel();
        }
        return 0;
    }

    @NonnullByDefault
    private class CustomMessageTarget<T extends CommandSource & Identifiable>
    implements Identifiable {
        private final UUID uuid;
        @Nullable
        private final Text displayName;
        private final Supplier<T> supplier;
        private final String targetName;

        private CustomMessageTarget(UUID uuid, @Nullable String targetName, Text displayName, Supplier<T> supplier) {
            this.uuid = uuid;
            this.targetName = targetName;
            this.displayName = displayName;
            this.supplier = supplier;
        }

        private Optional<T> get() {
            CommandSource t = (CommandSource)this.supplier.get();
            if (((Identifiable)t).getUniqueId().equals(this.uuid)) {
                return Optional.of(t);
            }
            return Optional.empty();
        }

        private Text getDisplayName() {
            return this.displayName == null ? Text.of((String)((CommandSource)this.supplier.get()).getName()) : this.displayName;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }
    }
}

