/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.qsml.module.ConfigurableModule;
import io.github.nucleuspowered.nucleus.internal.text.Tokens;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.modules.mute.commands.CheckMuteCommand;
import io.github.nucleuspowered.nucleus.modules.mute.config.MuteConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

@ModuleData(id="mute", name="Mute")
public class MuteModule
extends ConfigurableModule<MuteConfigAdapter>
implements MessageProviderTrait,
InternalServiceManagerTrait {
    public static final String ID = "mute";

    @Override
    public MuteConfigAdapter createAdapter() {
        return new MuteConfigAdapter();
    }

    @Override
    public void performEnableTasks() {
        this.createSeenModule(CheckMuteCommand.class, (CommandSource c, User u) -> {
            MuteHandler jh = this.getServiceUnchecked(MuteHandler.class);
            if (jh.isMuted((User)u)) {
                MuteData jd = jh.getPlayerMuteData((User)u).get();
                Text.Builder m = jd.getRemainingTime().isPresent() ? this.getMessageFor((CommandSource)c, "seen.ismuted.temp", Util.getTimeStringFromSeconds(jd.getRemainingTime().get().getSeconds())).toBuilder() : this.getMessageFor((CommandSource)c, "seen.ismuted.perm").toBuilder();
                return Lists.newArrayList((Object[])new Text[]{m.onClick((ClickAction)TextActions.runCommand((String)("/checkmute " + u.getName()))).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(c.getLocale(), "standard.clicktoseemore"))).build(), this.getMessageFor((CommandSource)c, "standard.reason", jd.getReason())});
            }
            return Lists.newArrayList((Object[])new Text[]{this.getMessageFor((CommandSource)c, "seen.notmuted")});
        });
    }

    @Override
    protected Map<String, Tokens.Translator> tokensToRegister() {
        return ImmutableMap.builder().put((Object)"muted", (Object)new Tokens.TrueFalseVariableTranslator(){
            final Optional<Text> def = Optional.of(Text.of((Object[])new Object[]{TextColors.GRAY, "[Muted]"}));

            @Override
            protected Optional<Text> getDefault() {
                return this.def;
            }

            @Override
            protected boolean condition(CommandSource commandSource) {
                return commandSource instanceof Player && MuteModule.this.getServiceUnchecked(MuteHandler.class).isMuted((User)((Player)commandSource));
            }
        }).build();
    }
}

