/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.MuteInfo;
import io.github.nucleuspowered.nucleus.api.service.NucleusMuteService;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.datamodules.MuteUserDataModule;
import io.github.nucleuspowered.nucleus.modules.mute.events.MuteEvent;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Identifiable;

@APIService(value=NucleusMuteService.class)
public class MuteHandler
implements ContextCalculator<Subject>,
NucleusMuteService,
MessageProviderTrait,
ServiceBase {
    private final UserDataManager ucl;
    private final Map<UUID, Boolean> muteContextCache = Maps.newHashMap();
    private final Context mutedContext = new Context("nucleus_muted", "true");
    private boolean globalMuteEnabled = false;
    private final List<UUID> voicedUsers = Lists.newArrayList();

    public MuteHandler() {
        this.ucl = Nucleus.getNucleus().getUserDataManager();
    }

    public void onMute(Player user) {
        this.getPlayerMuteData((User)user).ifPresent(x -> this.onMute((MuteData)x, user));
    }

    public void onMute(MuteData md, Player user) {
        if (md.getRemainingTime().isPresent()) {
            this.sendMessageTo((CommandSource)user, "mute.playernotify.time", new String[]{Util.getTimeStringFromSeconds(md.getRemainingTime().get().getSeconds())});
        } else {
            this.sendMessageTo((CommandSource)user, "mute.playernotify.standard");
        }
    }

    @Override
    public boolean isMuted(User user) {
        return this.getPlayerMuteData(user).isPresent();
    }

    @Override
    public Optional<MuteInfo> getPlayerMuteInfo(User user) {
        return this.getPlayerMuteData(user).map(x -> x);
    }

    public Optional<MuteData> getPlayerMuteData(User user) {
        Optional<MuteData> nu = this.ucl.get(user, false).map(x -> x.get(MuteUserDataModule.class).getMuteData().orElse(null));
        this.muteContextCache.put(user.getUniqueId(), nu.isPresent());
        return nu;
    }

    @Override
    public boolean mutePlayer(User user, String reason, @Nullable Duration duration, Cause cause) {
        UUID first = cause.first(User.class).map(Identifiable::getUniqueId).orElse(Util.consoleFakeUUID);
        return this.mutePlayer(user, new MuteData(first, reason, duration), cause);
    }

    public boolean mutePlayer(User user, MuteData data) {
        return this.mutePlayer(user, data, CauseStackHelper.createCause(Util.getObjectFromUUID(data.getMuterInternal())));
    }

    public boolean mutePlayer(User user, MuteData data, Cause cause) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)data);
        Optional<ModularUserService> nu = this.ucl.get(user);
        if (!nu.isPresent()) {
            return false;
        }
        Instant time = Instant.now();
        ModularUserService u = nu.get();
        Duration d = data.getRemainingTime().orElse(null);
        if (user.isOnline() && data.getTimeFromNextLogin().isPresent() && !data.getEndTimestamp().isPresent()) {
            data.setEndtimestamp(time.plus(data.getTimeFromNextLogin().get()));
        }
        u.get(MuteUserDataModule.class).setMuteData(data);
        this.muteContextCache.put(u.getUniqueId(), true);
        Sponge.getEventManager().post((Event)new MuteEvent.Muted(cause, user, d, (Text)Text.of((String)data.getReason())));
        return true;
    }

    public boolean unmutePlayer(User user) {
        return this.unmutePlayer(user, CauseStackHelper.createCause(new Object[0]), true);
    }

    @Override
    public boolean unmutePlayer(User user, Cause cause) {
        return this.unmutePlayer(user, cause, false);
    }

    public boolean unmutePlayer(User user, Cause cause, boolean expired) {
        Optional<ModularUserService> o;
        if (this.isMuted(user) && (o = this.ucl.get(user)).isPresent()) {
            o.get().get(MuteUserDataModule.class).removeMuteData();
            this.muteContextCache.put(user.getUniqueId(), false);
            Sponge.getEventManager().post((Event)new MuteEvent.Unmuted(cause, user, expired));
            user.getPlayer().ifPresent(x -> x.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("mute.elapsed", new String[0])));
            return true;
        }
        return false;
    }

    public boolean isGlobalMuteEnabled() {
        return this.globalMuteEnabled;
    }

    public void setGlobalMuteEnabled(boolean globalMuteEnabled) {
        if (this.globalMuteEnabled != globalMuteEnabled) {
            this.voicedUsers.clear();
        }
        this.globalMuteEnabled = globalMuteEnabled;
    }

    public boolean isVoiced(UUID uuid) {
        return this.voicedUsers.contains(uuid);
    }

    public void addVoice(UUID uuid) {
        this.voicedUsers.add(uuid);
    }

    public void removeVoice(UUID uuid) {
        this.voicedUsers.remove(uuid);
    }

    public void accumulateContexts(Subject calculable, Set<Context> accumulator) {
        UUID u;
        if (calculable instanceof User && this.muteContextCache.computeIfAbsent(u = ((User)calculable).getUniqueId(), k -> this.isMuted((User)calculable)).booleanValue()) {
            accumulator.add(this.mutedContext);
        }
    }

    public boolean matches(Context context, Subject subject) {
        return context.getKey().equals("nucleus_muted") && subject instanceof User && this.muteContextCache.computeIfAbsent(((User)subject).getUniqueId(), k -> this.isMuted((User)subject)) != false;
    }

    public boolean isMutedCached(User x) {
        return this.muteContextCache.containsKey(x.getUniqueId());
    }
}

