/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warn.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.WarningArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.warn.data.WarnData;
import io.github.nucleuspowered.nucleus.modules.warn.services.WarnHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.ADMIN)
@RunAsync
@NoModifiers
@RegisterCommand(value={"removewarning", "deletewarning", "delwarn"})
@NonnullByDefault
public class RemoveWarningCommand
extends AbstractCommand<CommandSource> {
    private final WarnHandler handler = (WarnHandler)this.getServiceUnchecked(WarnHandler.class);
    private final String warningKey = "warning";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"-remove", "r"}).buildWith(GenericArguments.onlyOne((CommandElement)new WarningArgument((Text)Text.of((String)this.warningKey), this.handler)))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        List<WarnData> warnings;
        WarningArgument.Result result = (WarningArgument.Result)args.getOne(this.warningKey).get();
        User user = result.user;
        boolean removePermanently = false;
        if (args.hasAny("remove")) {
            removePermanently = true;
        }
        if ((warnings = this.handler.getWarningsInternal(user)).isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkwarnings.none", user.getName()));
            return CommandResult.success();
        }
        if (this.handler.removeWarning(user, result.warnData, removePermanently, CauseStackHelper.createCause(src))) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.removewarning.success", user.getName()));
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.removewarning.failure", user.getName()));
        return CommandResult.empty();
    }
}

