/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Warp;
import io.github.nucleuspowered.nucleus.api.nucleusdata.WarpCategory;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.warp.WarpParameters;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@NonnullByDefault
@Permissions(prefix="warp")
@RegisterCommand(value={"setcategory"}, subcommandOf=WarpCommand.class)
public class SetCategoryCommand
extends AbstractCommand<CommandSource> {
    private final String categoryKey = "category";
    private final WarpHandler handler = (WarpHandler)this.getServiceUnchecked(WarpHandler.class);

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"r", "-remove", "-delete"}).flag(new String[]{"n", "-new"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{WarpParameters.WARP_NO_PERM, GenericArguments.optional((CommandElement)new SetCategoryWarpCategoryArgument((Text)Text.of((String)this.categoryKey)))}))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String warpName = ((Warp)args.getOne("warp").get()).getName();
        if (args.hasAny("r")) {
            if (this.handler.setWarpCategory(warpName, null)) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.category.removed", warpName));
                return CommandResult.success();
            }
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.category.noremove", warpName));
        }
        Optional categoryOp = args.getOne(this.categoryKey);
        if (!categoryOp.isPresent()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.category.required", new String[0]));
        }
        Tuple category = (Tuple)categoryOp.get();
        if (!args.hasAny("n") && !((Boolean)category.getSecond()).booleanValue()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.category.requirenew", (String)category.getFirst()).toBuilder().onClick((ClickAction)TextActions.runCommand((String)("/warp setcategory -n " + warpName + " " + (String)category.getFirst()))).build());
            return CommandResult.empty();
        }
        if (this.handler.setWarpCategory(warpName, (String)category.getFirst())) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.category.added", (String)category.getFirst(), warpName));
            return CommandResult.success();
        }
        WarpCategory c = this.handler.getWarpCategoryOrDefault((String)category.getFirst());
        throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.warp.category.couldnotadd", new Text[]{c.getDisplayName(), Text.of((String)warpName)}));
    }

    private class SetCategoryWarpCategoryArgument
    extends CommandElement {
        public SetCategoryWarpCategoryArgument(Text key) {
            super(key);
        }

        @Nullable
        protected Object parseValue(@Nonnull CommandSource source, @Nonnull CommandArgs args) throws ArgumentParseException {
            String arg = args.next();
            return Tuple.of((Object)arg, (Object)SetCategoryCommand.this.handler.getWarpsWithCategories().keySet().stream().filter(Objects::nonNull).anyMatch(x -> x.getId().equals(arg)));
        }

        @Nonnull
        public List<String> complete(@Nonnull CommandSource src, @Nonnull CommandArgs args, @Nonnull CommandContext context) {
            return SetCategoryCommand.this.handler.getWarpsWithCategories().keySet().stream().filter(Objects::isNull).map(WarpCategory::getId).collect(Collectors.toList());
        }
    }
}

