/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Warp;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.warp.WarpParameters;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpHandler;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@NonnullByDefault
@Permissions(prefix="warp")
@RegisterCommand(value={"setdescription"}, subcommandOf=WarpCommand.class)
public class SetDescriptionCommand
extends AbstractCommand<CommandSource> {
    private final WarpHandler handler = (WarpHandler)this.getServiceUnchecked(WarpHandler.class);

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"r", "-remove", "-delete"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{WarpParameters.WARP_NO_PERM, NucleusParameters.OPTIONAL_DESCRIPTION}))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String warpName = ((Warp)args.getOne("warp").get()).getName();
        if (args.hasAny("r")) {
            if (this.handler.setWarpDescription(warpName, null)) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.description.removed", warpName));
                return CommandResult.success();
            }
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.description.noremove", warpName));
        }
        Text message = TextSerializers.FORMATTING_CODE.deserialize((String)args.getOne("description").get());
        if (this.handler.setWarpDescription(warpName, message)) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.warp.description.added", new Text[]{message, Text.of((String)warpName)}));
            return CommandResult.success();
        }
        throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.warp.description.couldnotadd", new Text[]{Text.of((String)warpName)}));
    }
}

