/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.ImprovedCatalogTypeArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.ImprovedGameModeArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfigAdapter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.CatalogTypes;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.difficulty.Difficulties;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="world", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"create"}, subcommandOf=WorldCommand.class)
@NonnullByDefault
public class CreateWorldCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final DataQuery uuidLeast = DataQuery.of((String[])new String[]{"SpongeData", "UUIDLeast"});
    private final DataQuery uuidMost = DataQuery.of((String[])new String[]{"SpongeData", "UUIDMost"});
    private final DataQuery levelName = DataQuery.of((String[])new String[]{"Data", "LevelName"});
    private final DataQuery toId = DataQuery.of((String[])new String[]{"SpongeData", "dimensionId"});
    private final String preset = "preset";
    private final String name = "name";
    private final String dimension = "dimension";
    private final String generator = "generator";
    private final String gamemode = "gamemode";
    private final String difficulty = "difficulty";
    private final String modifier = "modifier";
    private final String seed = "seed";
    @Nullable
    private Long worldBorderDefault;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"preset"), WorldArchetype.class)), new String[]{"p", "-preset"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ExtendedDimensionArgument((Text)Text.of((String)"dimension"))), new String[]{"d", "-dimension"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"generator"), CatalogTypes.GENERATOR_TYPE)), new String[]{"g", "-generator"}).valueFlag((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"modifier"), CatalogTypes.WORLD_GENERATOR_MODIFIER), new String[]{"m", "-modifier"}).valueFlag(GenericArguments.onlyOne((CommandElement)GenericArguments.longNum((Text)Text.of((String)"seed"))), new String[]{"s", "-seed"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedGameModeArgument((Text)Text.of((String)"gamemode"))), new String[]{"-gm", "-gamemode"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"difficulty"), CatalogTypes.DIFFICULTY)), new String[]{"-di", "-difficulty"}).flag(new String[]{"n", "-nostructures"}).flag(new String[]{"i"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"l")), new String[]{"l", "-loadonstartup"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"k")), new String[]{"k", "-keepspawnloaded"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"c")), new String[]{"c", "-allowcommands"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"b")), new String[]{"b", "-bonuschest"}).buildWith(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"name"))))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        boolean bonusChest;
        String nameInput = (String)args.getOne("name").get();
        Optional dimensionInput = args.getOne("dimension");
        Optional generatorInput = args.getOne("generator");
        Optional gamemodeInput = args.getOne("gamemode");
        Optional difficultyInput = args.getOne("difficulty");
        Collection modifiers = args.getAll("modifier");
        Optional seedInput = args.getOne("seed");
        boolean genStructures = !args.hasAny("n");
        boolean loadOnStartup = !args.hasAny("l") || args.getOne("l").orElse(true) != false;
        boolean keepSpawnLoaded = !args.hasAny("k") || args.getOne("k").orElse(true) != false;
        boolean allowCommands = !args.hasAny("c") || args.getOne("c").orElse(true) != false;
        boolean bl = bonusChest = !args.hasAny("b") || args.getOne("b").orElse(true) != false;
        if (Sponge.getServer().getAllWorldProperties().stream().anyMatch(x -> x.getWorldName().equalsIgnoreCase(nameInput))) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.create.exists", nameInput));
        }
        Path worldPath = Sponge.getGame().getGameDirectory().resolve("world");
        Path worldDir = worldPath.resolve(nameInput);
        if (!args.hasAny("i") && Files.exists(worldDir, new LinkOption[0])) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.import.noexist", nameInput));
        }
        if (args.hasAny("i") && Files.exists(worldDir, new LinkOption[0])) {
            this.onImport(worldDir, nameInput);
        }
        WorldArchetype.Builder worldSettingsBuilder = WorldArchetype.builder().enabled(true);
        if (args.hasAny("preset")) {
            WorldArchetype preset1 = (WorldArchetype)args.getOne("preset").get();
            worldSettingsBuilder.from((Object)preset1);
            dimensionInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).dimension(arg_0));
            generatorInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).generator(arg_0));
            gamemodeInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).gameMode(arg_0));
            difficultyInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).difficulty(arg_0));
            if (!modifiers.isEmpty()) {
                modifiers.addAll(preset1.getGeneratorModifiers());
                worldSettingsBuilder.generatorModifiers(modifiers.toArray(new WorldGeneratorModifier[modifiers.size()]));
            }
        } else {
            worldSettingsBuilder.dimension(dimensionInput.orElse(DimensionTypes.OVERWORLD)).generator(generatorInput.orElse(GeneratorTypes.DEFAULT)).gameMode(gamemodeInput.orElse(GameModes.SURVIVAL)).difficulty(difficultyInput.orElse(Difficulties.NORMAL));
            if (!modifiers.isEmpty()) {
                worldSettingsBuilder.generatorModifiers(modifiers.toArray(new WorldGeneratorModifier[modifiers.size()]));
            }
        }
        worldSettingsBuilder.loadsOnStartup(loadOnStartup).keepsSpawnLoaded(keepSpawnLoaded).usesMapFeatures(genStructures).commandsAllowed(allowCommands).generateBonusChest(bonusChest);
        seedInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).seed(arg_0));
        WorldArchetype wa = worldSettingsBuilder.build(nameInput.toLowerCase(), nameInput);
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.create.begin", nameInput));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.create.newparams", wa.getDimensionType().getName(), wa.getGeneratorType().getName(), CreateWorldCommand.modifierString(modifiers), wa.getGameMode().getName(), wa.getDifficulty().getName()));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.create.newparams2", String.valueOf(loadOnStartup), String.valueOf(keepSpawnLoaded), String.valueOf(genStructures), String.valueOf(allowCommands), String.valueOf(bonusChest)));
        WorldProperties worldProperties = Sponge.getGame().getServer().createWorldProperties(nameInput, wa);
        if (this.worldBorderDefault != null && this.worldBorderDefault > 0L) {
            worldProperties.setWorldBorderDiameter((double)this.worldBorderDefault.longValue());
        }
        worldProperties.setDifficulty(wa.getDifficulty());
        if (!Sponge.getServer().saveWorldProperties(worldProperties)) {
            throw ReturnMessageException.fromKey("command.world.create.couldnotsave", nameInput);
        }
        Optional world = Sponge.getGame().getServer().loadWorld(worldProperties);
        if (world.isPresent()) {
            ((World)world.get()).getProperties().setDifficulty(wa.getDifficulty());
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.create.success", nameInput));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.world.create.worldfailedtoload", nameInput);
    }

    private OutputStream getOutput(boolean gzip, Path file) throws IOException {
        OutputStream os = Files.newOutputStream(file, new OpenOption[0]);
        if (gzip) {
            return new GZIPOutputStream(os, true);
        }
        return os;
    }

    private void onImport(Path world, String name) {
        Throwable throwable;
        Object gzip;
        DataContainer dc;
        InputStream is;
        boolean gz;
        Path level = world.resolve("level.dat");
        Path levelSponge = world.resolve("level_sponge.dat");
        if (Files.exists(level, new LinkOption[0])) {
            gz = false;
            try {
                try {
                    is = Files.newInputStream(level, StandardOpenOption.READ);
                    Throwable throwable2 = null;
                    try {
                        dc = DataFormats.NBT.readFrom(is);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (is != null) {
                            if (throwable2 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (EOFException ex) {
                    gzip = new GZIPInputStream(Files.newInputStream(level, StandardOpenOption.READ));
                    throwable = null;
                    try {
                        dc = DataFormats.NBT.readFrom((InputStream)gzip);
                        gz = true;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (gzip != null) {
                            if (throwable != null) {
                                try {
                                    ((GZIPInputStream)gzip).close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                ((GZIPInputStream)gzip).close();
                            }
                        }
                    }
                }
                Files.copy(level, world.resolve("level.dat.nbak"), StandardCopyOption.REPLACE_EXISTING);
                dc.set(this.levelName, (Object)name);
                OutputStream os = this.getOutput(gz, level);
                gzip = null;
                try {
                    DataFormats.NBT.writeTo(os, (DataView)dc);
                    os.flush();
                }
                catch (Throwable throwable7) {
                    gzip = throwable7;
                    throw throwable7;
                }
                finally {
                    if (os != null) {
                        if (gzip != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable8) {
                                ((Throwable)gzip).addSuppressed(throwable8);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                if (Nucleus.getNucleus().isDebugMode()) {
                    e.printStackTrace();
                }
                Nucleus.getNucleus().getLogger().warn("Could not read the level.dat. Ignoring.");
            }
        }
        if (Files.exists(levelSponge, new LinkOption[0])) {
            gz = false;
            try {
                try {
                    is = Files.newInputStream(levelSponge, StandardOpenOption.READ);
                    gzip = null;
                    try {
                        dc = DataFormats.NBT.readFrom(is);
                    }
                    catch (Throwable throwable9) {
                        gzip = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (is != null) {
                            if (gzip != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable10) {
                                    ((Throwable)gzip).addSuppressed(throwable10);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (EOFException ex) {
                    gzip = new GZIPInputStream(Files.newInputStream(levelSponge, StandardOpenOption.READ));
                    throwable = null;
                    try {
                        dc = DataFormats.NBT.readFrom((InputStream)gzip);
                        gz = true;
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (gzip != null) {
                            if (throwable != null) {
                                try {
                                    ((GZIPInputStream)gzip).close();
                                }
                                catch (Throwable throwable12) {
                                    throwable.addSuppressed(throwable12);
                                }
                            } else {
                                ((GZIPInputStream)gzip).close();
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                if (Nucleus.getNucleus().isDebugMode()) {
                    e.printStackTrace();
                }
                Nucleus.getNucleus().getLogger().warn("Could not read the level_sponge.dat. Ignoring.");
                return;
            }
            Set si = Sponge.getServer().getAllWorldProperties().stream().map(x -> x.getAdditionalProperties().getInt(this.toId).orElse(0)).collect(Collectors.toSet());
            if (!dc.getInt(this.toId).map(si::contains).orElse(false).booleanValue()) {
                for (int i = 2; i < Integer.MAX_VALUE; ++i) {
                    if (si.contains(i)) continue;
                    dc.set(this.toId, (Object)i);
                    break;
                }
            }
            UUID uuid = UUID.randomUUID();
            dc.set(this.uuidLeast, (Object)uuid.getLeastSignificantBits());
            dc.set(this.uuidMost, (Object)uuid.getMostSignificantBits());
            try {
                Files.copy(levelSponge, world.resolve("level_sponge.dat.nbak"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                if (Nucleus.getNucleus().isDebugMode()) {
                    e.printStackTrace();
                }
                Nucleus.getNucleus().getLogger().warn("Could not backup the level_sponge.dat. Ignoring.");
                return;
            }
            try (OutputStream os = this.getOutput(gz, levelSponge);){
                DataFormats.NBT.writeTo(os, (DataView)dc);
                os.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                Nucleus.getNucleus().getLogger().warn("Could not save the level_sponge.dat. Ignoring.");
            }
        }
    }

    static String modifierString(Collection<WorldGeneratorModifier> cw) {
        if (cw.isEmpty()) {
            return Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.world.create.nomodifiers", new String[0]);
        }
        StringBuilder sb = new StringBuilder();
        cw.forEach(x -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(x.getName());
        });
        return sb.toString();
    }

    @Override
    public void onReload() throws Exception {
        this.worldBorderDefault = ((WorldConfig)((WorldConfigAdapter)this.getServiceUnchecked(WorldConfigAdapter.class)).getNodeOrDefault()).getWorldBorderDefault().orElse(null);
    }

    @NonnullByDefault
    public static class ExtendedDimensionArgument
    extends CommandElement {
        private static HashMap<String, DimensionType> replacement = new HashMap<String, DimensionType>(){
            {
                this.put("dim0", DimensionTypes.OVERWORLD);
                this.put("dim-1", DimensionTypes.NETHER);
                this.put("dim1", DimensionTypes.THE_END);
            }
        };

        private ExtendedDimensionArgument(@Nullable Text key) {
            super(key);
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String arg = args.next();
            if (replacement.containsKey(arg.toLowerCase())) {
                return replacement.get(arg.toLowerCase());
            }
            String arg2 = arg;
            if (!arg2.contains(":")) {
                arg2 = "minecraft:" + arg2;
            }
            return Sponge.getRegistry().getType(DimensionType.class, arg2).orElseThrow(() -> args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.dimensiontype.notfound", arg)));
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            List<String> ids = Sponge.getRegistry().getAllOf(DimensionType.class).stream().map(CatalogType::getId).collect(Collectors.toList());
            try {
                String a = args.peek();
                return ids.stream().filter(x -> x.startsWith(a)).collect(Collectors.toList());
            }
            catch (Exception e) {
                return ids;
            }
        }
    }
}

