/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.DefaultLogger;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.LoggerProxy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Metadata;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleSpec;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Procedure;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.SystemConfig;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ConstructionPhase;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.LoadingStatus;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ModulePhase;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.IncorrectAdapterTypeException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.MissingDependencyException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleDiscoveryException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleLoaderException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.UndisableableModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.ModuleEnabler;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public abstract class ModuleContainer {
    private ConstructionPhase currentPhase = ConstructionPhase.INITALISED;
    protected final Map<String, ModuleSpec> discoveredModules = Maps.newLinkedHashMap();
    protected final Map<String, Module.RuntimeDisableable> enabledDisableableModules = Maps.newHashMap();
    protected final SystemConfig<?, ? extends ConfigurationLoader<?>> config;
    protected final LoggerProxy loggerProxy;
    private final Procedure onPreEnable;
    private final Procedure onEnable;
    private final Procedure onPostEnable;
    private final ModuleEnabler enabler;
    private final boolean requireAnnotation;
    private final boolean processDoNotMerge;
    private final Function<Module, String> headerProcessor;
    private final Function<Class<? extends Module>, String> descriptionProcessor;
    private final String moduleSection;
    @Nullable
    private final String moduleSectionHeader;

    protected <N extends ConfigurationNode> ModuleContainer(ConfigurationLoader<N> configurationLoader, LoggerProxy loggerProxy, ModuleEnabler moduleEnabler, Procedure onPreEnable, Procedure onEnable, Procedure onPostEnable, Function<ConfigurationOptions, ConfigurationOptions> configOptions, boolean requireAnnotation, boolean processDoNotMerge, @Nullable Function<Module, String> headerProcessor, @Nullable Function<Class<? extends Module>, String> descriptionProcessor, String moduleSection, @Nullable String moduleSectionHeader) throws QuickStartModuleDiscoveryException {
        try {
            this.config = new SystemConfig(configurationLoader, loggerProxy, configOptions);
            this.loggerProxy = loggerProxy;
            this.enabler = moduleEnabler;
            this.onPreEnable = onPreEnable;
            this.onPostEnable = onPostEnable;
            this.onEnable = onEnable;
            this.requireAnnotation = requireAnnotation;
            this.processDoNotMerge = processDoNotMerge;
            this.descriptionProcessor = descriptionProcessor == null ? m -> {
                ModuleData md = m.getAnnotation(ModuleData.class);
                if (md != null) {
                    return md.description();
                }
                return "";
            } : descriptionProcessor;
            this.headerProcessor = headerProcessor == null ? m -> "" : headerProcessor;
            this.moduleSection = moduleSection;
            this.moduleSectionHeader = moduleSectionHeader;
        }
        catch (Exception e) {
            throw new QuickStartModuleDiscoveryException("Unable to start QuickStart", e);
        }
    }

    public final void startDiscover() throws QuickStartModuleDiscoveryException {
        try {
            Preconditions.checkState((this.currentPhase == ConstructionPhase.INITALISED ? 1 : 0) != 0);
            this.currentPhase = ConstructionPhase.DISCOVERING;
            Set<Class<? extends Module>> modules = this.discoverModules();
            HashMap discovered = Maps.newHashMap();
            for (Class<? extends Module> s : modules) {
                ModuleSpec ms;
                String id;
                if (s.isAnnotationPresent(ModuleData.class)) {
                    ModuleData md = s.getAnnotation(ModuleData.class);
                    id = md.id().toLowerCase();
                    ms = new ModuleSpec(s, md);
                } else {
                    if (this.requireAnnotation) {
                        this.loggerProxy.warn(MessageFormat.format("The module class {0} does not have a ModuleData annotation associated with it. It is not being loaded as the module container requires the annotation to be present.", s.getClass().getName()));
                        continue;
                    }
                    id = s.getClass().getName().toLowerCase();
                    this.loggerProxy.warn(MessageFormat.format("The module {0} does not have a ModuleData annotation associated with it. We're just assuming an ID of {0}.", id));
                    ms = new ModuleSpec(s, id, id, LoadingStatus.ENABLED, false);
                }
                if (discovered.containsKey(id)) {
                    throw new QuickStartModuleDiscoveryException("Duplicate module ID \"" + id + "\" was discovered - loading cannot continue.");
                }
                discovered.put(id, ms);
            }
            this.resolveDependencyOrder(discovered);
            List<ModuleSpec> moduleSpecList = this.discoveredModules.entrySet().stream().filter(x -> !((ModuleSpec)x.getValue()).isMandatory()).map(Map.Entry::getValue).collect(Collectors.toList());
            this.config.attachModulesConfig(moduleSpecList, this.descriptionProcessor, this.moduleSection, this.moduleSectionHeader);
            this.config.saveAdapterDefaults(false);
            try {
                ((HashMap)this.config.getConfigAdapter().getNode()).forEach((k, v) -> {
                    try {
                        ModuleSpec ms = this.discoveredModules.get(k);
                        if (ms != null) {
                            ms.setStatus((LoadingStatus)((Object)v));
                        } else {
                            this.loggerProxy.warn(String.format("Ignoring module entry %s in the configuration file: module does not exist.", k));
                        }
                    }
                    catch (IllegalStateException ex) {
                        this.loggerProxy.warn("A mandatory module can't have its status changed by config. Falling back to FORCELOAD for " + k);
                    }
                });
            }
            catch (ObjectMappingException e) {
                this.loggerProxy.warn("Could not load modules config, falling back to defaults.");
                e.printStackTrace();
            }
            this.currentPhase = ConstructionPhase.DISCOVERED;
        }
        catch (QuickStartModuleDiscoveryException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new QuickStartModuleDiscoveryException("Unable to discover QuickStart modules", e);
        }
    }

    private void resolveDependencyOrder(Map<String, ModuleSpec> modules) throws Exception {
        this.processDependencyStep(modules, x -> ((ModuleSpec)x.getValue()).getDependencies().isEmpty() && ((ModuleSpec)x.getValue()).getSoftDependencies().isEmpty());
        while (!modules.isEmpty()) {
            Set<String> addedModules = this.discoveredModules.keySet();
            this.processDependencyStep(modules, x -> addedModules.containsAll(((ModuleSpec)x.getValue()).getDependencies()) && addedModules.containsAll(((ModuleSpec)x.getValue()).getSoftDependencies()));
        }
    }

    private void processDependencyStep(Map<String, ModuleSpec> modules, Predicate<Map.Entry<String, ModuleSpec>> predicate) throws Exception {
        List<Map.Entry> modulesToAdd = modules.entrySet().stream().filter(predicate).sorted((x, y) -> ((ModuleSpec)x.getValue()).isMandatory() == ((ModuleSpec)y.getValue()).isMandatory() ? ((String)x.getKey()).compareTo((String)y.getKey()) : Boolean.compare(((ModuleSpec)x.getValue()).isMandatory(), ((ModuleSpec)y.getValue()).isMandatory())).collect(Collectors.toList());
        if (modulesToAdd.isEmpty()) {
            throw new IllegalStateException("Some modules have circular dependencies: " + modules.keySet().stream().collect(Collectors.joining(", ")));
        }
        modulesToAdd.forEach(x -> {
            this.discoveredModules.put((String)x.getKey(), (ModuleSpec)x.getValue());
            modules.remove(x.getKey());
        });
    }

    private boolean dependenciesSatisfied(ModuleSpec moduleSpec, Set<String> enabledModules) {
        if (moduleSpec.getDependencies().isEmpty()) {
            return true;
        }
        for (String m : moduleSpec.getDependencies()) {
            if (enabledModules.contains(m) && this.dependenciesSatisfied(this.discoveredModules.get(m), enabledModules)) continue;
            return false;
        }
        return true;
    }

    protected abstract Set<Class<? extends Module>> discoverModules() throws Exception;

    public ConstructionPhase getCurrentPhase() {
        return this.currentPhase;
    }

    public Set<String> getModules() {
        return this.getModules(ModuleStatusTristate.ENABLE);
    }

    public Set<String> getModules(ModuleStatusTristate enabledOnly) {
        Preconditions.checkNotNull((Object)((Object)enabledOnly));
        Preconditions.checkState((this.currentPhase != ConstructionPhase.INITALISED && this.currentPhase != ConstructionPhase.DISCOVERING ? 1 : 0) != 0);
        return this.discoveredModules.entrySet().stream().filter(enabledOnly.statusPredicate).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Map<String, LoadingStatus> getModulesWithLoadingState() {
        Preconditions.checkState((this.currentPhase != ConstructionPhase.INITALISED && this.currentPhase != ConstructionPhase.DISCOVERING ? 1 : 0) != 0);
        return ImmutableMap.copyOf(this.discoveredModules.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((ModuleSpec)v.getValue()).getStatus())));
    }

    public boolean isModuleLoaded(String moduleId) throws NoModuleException {
        if (this.currentPhase != ConstructionPhase.ENABLING && this.currentPhase != ConstructionPhase.ENABLED) {
            return false;
        }
        ModuleSpec ms = this.discoveredModules.get(moduleId.toLowerCase());
        if (ms == null) {
            throw new NoModuleException(moduleId);
        }
        return ms.getPhase() == ModulePhase.ENABLED;
    }

    public void disableModule(String moduleName) throws UndisableableModuleException, NoModuleException {
        if (this.currentPhase == ConstructionPhase.DISCOVERED) {
            ModuleSpec ms = this.discoveredModules.get(moduleName.toLowerCase());
            if (ms == null) {
                throw new NoModuleException(moduleName);
            }
            if (ms.isMandatory() || ms.getStatus() == LoadingStatus.FORCELOAD) {
                throw new UndisableableModuleException(moduleName);
            }
            ms.setStatus(LoadingStatus.DISABLED);
        } else {
            Preconditions.checkState((this.currentPhase == ConstructionPhase.ENABLED ? 1 : 0) != 0);
            ModuleSpec ms = this.discoveredModules.get(moduleName.toLowerCase());
            Module.RuntimeDisableable m = this.enabledDisableableModules.get(moduleName.toLowerCase());
            if (!ms.isRuntimeAlterable()) {
                throw new UndisableableModuleException(moduleName.toLowerCase(), "Cannot disable this module at runtime!");
            }
            Preconditions.checkState((ms.getPhase() != ModulePhase.ERRORED ? 1 : 0) != 0, (Object)"Cannot disable this module as it errored!");
            Preconditions.checkState((ms.getPhase() == ModulePhase.ENABLED ? 1 : 0) != 0, (Object)"Cannot disable this module as it is not enabled!");
            m.onDisable();
            this.detachConfig(ms.getName());
            ms.setPhase(ModulePhase.DISABLED);
            this.enabledDisableableModules.remove(moduleName.toLowerCase());
        }
    }

    protected abstract Module getModule(ModuleSpec var1) throws Exception;

    public void loadModules(boolean failOnOneError) throws QuickStartModuleLoaderException.Construction, QuickStartModuleLoaderException.Enabling {
        Map.Entry module;
        Preconditions.checkArgument((this.currentPhase == ConstructionPhase.DISCOVERED ? 1 : 0) != 0);
        this.currentPhase = ConstructionPhase.ENABLING;
        Set<String> disabledModules = this.getModules(ModuleStatusTristate.DISABLE);
        while (!disabledModules.isEmpty()) {
            List<ModuleSpec> toDisable = this.getModules(ModuleStatusTristate.ENABLE).stream().map(this.discoveredModules::get).filter(x -> !Collections.disjoint(disabledModules, x.getDependencies())).collect(Collectors.toList());
            if (toDisable.isEmpty()) break;
            if (toDisable.stream().anyMatch(ModuleSpec::isMandatory)) {
                String s = toDisable.stream().filter(ModuleSpec::isMandatory).map(ModuleSpec::getId).collect(Collectors.joining(", "));
                Class<? extends Module> m = toDisable.stream().filter(ModuleSpec::isMandatory).findFirst().get().getModuleClass();
                throw new QuickStartModuleLoaderException.Construction(m, "Tried to disable mandatory module", new IllegalStateException("Dependency failure, tried to disable a mandatory module (" + s + ")"));
            }
            toDisable.forEach(k -> {
                k.setStatus(LoadingStatus.DISABLED);
                disabledModules.add(k.getId());
            });
        }
        this.getModules(ModuleStatusTristate.DISABLE).forEach(k -> this.discoveredModules.get(k).setPhase(ModulePhase.DISABLED));
        ConcurrentMap modules = Maps.newConcurrentMap();
        for (String s : this.getModules(ModuleStatusTristate.ENABLE)) {
            ModuleSpec ms = this.discoveredModules.get(s);
            try {
                modules.put(s, this.getModule(ms));
                ms.setPhase(ModulePhase.CONSTRUCTED);
            }
            catch (Exception construction) {
                construction.printStackTrace();
                ms.setPhase(ModulePhase.ERRORED);
                this.loggerProxy.error("The module " + ms.getModuleClass().getName() + " failed to construct.");
                if (!failOnOneError) continue;
                this.currentPhase = ConstructionPhase.ERRORED;
                throw new QuickStartModuleLoaderException.Construction(ms.getModuleClass(), "The module " + ms.getModuleClass().getName() + " failed to construct.", construction);
            }
        }
        if (modules.isEmpty()) {
            this.currentPhase = ConstructionPhase.ERRORED;
            throw new QuickStartModuleLoaderException.Construction(null, "No modules were constructed.", null);
        }
        int size = modules.size();
        Iterator im = modules.entrySet().iterator();
        while (im.hasNext()) {
            module = im.next();
            try {
                ((Module)module.getValue()).checkExternalDependencies();
            }
            catch (MissingDependencyException ex) {
                this.discoveredModules.get(module.getKey()).setStatus(LoadingStatus.DISABLED);
                this.discoveredModules.get(module.getKey()).setPhase(ModulePhase.DISABLED);
                this.loggerProxy.warn("Module " + (String)module.getKey() + " can not be enabled because an external dependency could not be satisfied.");
                this.loggerProxy.warn("Message was: " + ex.getMessage());
                im.remove();
            }
        }
        while (size != modules.size()) {
            size = modules.size();
            im = modules.entrySet().iterator();
            while (im.hasNext()) {
                module = im.next();
                if (this.dependenciesSatisfied(this.discoveredModules.get(module.getKey()), this.getModules(ModuleStatusTristate.ENABLE))) continue;
                im.remove();
                this.loggerProxy.warn("Module " + (String)module.getKey() + " can not be enabled because an external dependency on a module it depends on could not be satisfied.");
                this.discoveredModules.get(module.getKey()).setStatus(LoadingStatus.DISABLED);
                this.discoveredModules.get(module.getKey()).setPhase(ModulePhase.DISABLED);
            }
        }
        for (EnablePhase[] s : modules.keySet()) {
            Module m = (Module)modules.get(s);
            try {
                this.attachConfig((String)s, m);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!failOnOneError) continue;
                throw new QuickStartModuleLoaderException.Enabling(m.getClass(), "Failed to attach config.", e);
            }
        }
        HashMap c = new HashMap(modules);
        for (EnablePhase v : EnablePhase.values()) {
            this.loggerProxy.info(String.format("Starting phase: %s", v.name()));
            v.onStart(this);
            for (String s : c.keySet()) {
                ModuleSpec ms = this.discoveredModules.get(s);
                if (ms.getPhase() == ModulePhase.ERRORED) continue;
                try {
                    Module m = (Module)modules.get(s);
                    v.onModuleAction(this, this.enabler, m, ms);
                }
                catch (Exception construction) {
                    construction.printStackTrace();
                    modules.remove(s);
                    if (v != EnablePhase.POSTENABLE) {
                        ms.setPhase(ModulePhase.ERRORED);
                        this.loggerProxy.error("The module " + ms.getModuleClass().getName() + " failed to enable.");
                        if (!failOnOneError) continue;
                        this.currentPhase = ConstructionPhase.ERRORED;
                        throw new QuickStartModuleLoaderException.Enabling(ms.getModuleClass(), "The module " + ms.getModuleClass().getName() + " failed to enable.", construction);
                    }
                    this.loggerProxy.error("The module " + ms.getModuleClass().getName() + " failed to post-enable.");
                }
            }
        }
        if (c.isEmpty()) {
            this.currentPhase = ConstructionPhase.ERRORED;
            throw new QuickStartModuleLoaderException.Enabling(null, "No modules were enabled.", null);
        }
        try {
            this.config.saveAdapterDefaults(this.processDoNotMerge);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currentPhase = ConstructionPhase.ENABLED;
    }

    public void runtimeEnable(String name) throws Exception {
        Preconditions.checkState((this.currentPhase == ConstructionPhase.ENABLED ? 1 : 0) != 0);
        Preconditions.checkState((!this.isModuleLoaded(name) ? 1 : 0) != 0, (Object)"Module is already loaded!");
        ModuleSpec ms = this.discoveredModules.get(name);
        Preconditions.checkState((boolean)Module.RuntimeDisableable.class.isAssignableFrom(ms.getModuleClass()), (Object)("Module " + name + " cannot be enabled at runtime!"));
        try {
            Module.RuntimeDisableable module = (Module.RuntimeDisableable)this.getModule(ms);
            ms.setPhase(ModulePhase.CONSTRUCTED);
            module.checkExternalDependencies();
            for (EnablePhase v : EnablePhase.values()) {
                try {
                    v.onModuleAction(this, this.enabler, module, ms);
                }
                catch (Exception e) {
                    if (v == EnablePhase.POSTENABLE) {
                        this.loggerProxy.error("The module " + ms.getModuleClass().getName() + " failed to post-enable.");
                        continue;
                    }
                    throw e;
                }
            }
        }
        catch (Exception construction) {
            ms.setPhase(ModulePhase.ERRORED);
            throw construction;
        }
    }

    private void attachConfig(String name, Module m) throws Exception {
        Optional<AbstractConfigAdapter<?>> a = m.getConfigAdapter();
        if (a.isPresent()) {
            this.config.attachConfigAdapter(name, a.get(), this.headerProcessor.apply(m));
        }
    }

    private void detachConfig(String name) {
        this.config.detachConfigAdapter(name);
    }

    public final <R extends AbstractConfigAdapter<?>> R getConfigAdapterForModule(String module, Class<R> adapterClass) throws NoModuleException, IncorrectAdapterTypeException {
        return this.config.getConfigAdapterForModule(module, adapterClass);
    }

    public final void saveSystemConfig() throws IOException {
        this.config.save();
    }

    public final void refreshSystemConfig() throws IOException {
        this.config.save(true);
    }

    public final void reloadSystemConfig() throws IOException {
        this.config.load();
    }

    public final Optional<String> getIdForModule(Module module) {
        return this.discoveredModules.entrySet().stream().filter(x -> ((ModuleSpec)x.getValue()).getModuleClass() == module.getClass()).map(Map.Entry::getKey).findFirst();
    }

    private static enum EnablePhase implements ConstructPhase
    {
        PREENABLE{

            @Override
            public void onStart(ModuleContainer container) {
                container.onPreEnable.invoke();
            }

            @Override
            public void onModuleAction(ModuleContainer moduleContainer, ModuleEnabler enabler, Module module, ModuleSpec ms) throws Exception {
                enabler.preEnableModule(module);
            }
        }
        ,
        ENABLE{

            @Override
            public void onStart(ModuleContainer container) {
                container.onEnable.invoke();
            }

            @Override
            public void onModuleAction(ModuleContainer moduleContainer, ModuleEnabler enabler, Module module, ModuleSpec ms) throws Exception {
                enabler.enableModule(module);
                ms.setPhase(ModulePhase.ENABLED);
                if (module instanceof Module.RuntimeDisableable) {
                    moduleContainer.enabledDisableableModules.put(ms.getId(), (Module.RuntimeDisableable)module);
                }
            }
        }
        ,
        POSTENABLE{

            @Override
            public void onStart(ModuleContainer container) {
                container.onPostEnable.invoke();
            }

            @Override
            public void onModuleAction(ModuleContainer moduleContainer, ModuleEnabler enabler, Module module, ModuleSpec ms) throws Exception {
                enabler.postEnableModule(module);
            }
        };

    }

    private static interface ConstructPhase {
        public void onStart(ModuleContainer var1);

        public void onModuleAction(ModuleContainer var1, ModuleEnabler var2, Module var3, ModuleSpec var4) throws Exception;
    }

    public static enum ModuleStatusTristate {
        ENABLE(k -> ((ModuleSpec)k.getValue()).getStatus() != LoadingStatus.DISABLED && ((ModuleSpec)k.getValue()).getPhase() != ModulePhase.ERRORED && ((ModuleSpec)k.getValue()).getPhase() != ModulePhase.DISABLED),
        DISABLE(k -> !ModuleStatusTristate.ENABLE.statusPredicate.test((Map.Entry<String, ModuleSpec>)k)),
        ALL(k -> true);

        private final Predicate<Map.Entry<String, ModuleSpec>> statusPredicate;

        private ModuleStatusTristate(Predicate<Map.Entry<String, ModuleSpec>> p) {
            this.statusPredicate = p;
        }
    }

    public static abstract class Builder<R extends ModuleContainer, T extends Builder<R, T>> {
        protected ConfigurationLoader<? extends ConfigurationNode> configurationLoader;
        protected boolean requireAnnotation = false;
        protected LoggerProxy loggerProxy;
        protected Procedure onPreEnable = () -> {};
        protected Procedure onEnable = () -> {};
        protected Procedure onPostEnable = () -> {};
        protected Function<ConfigurationOptions, ConfigurationOptions> configurationOptionsTransformer = x -> x;
        protected ModuleEnabler enabler = ModuleEnabler.SIMPLE_INSTANCE;
        protected boolean doNotMerge = false;
        @Nullable
        protected Function<Class<? extends Module>, String> moduleDescriptionHandler = null;
        @Nullable
        protected Function<Module, String> moduleConfigurationHeader = null;
        protected String moduleConfigSection = "modules";
        @Nullable
        protected String moduleDescription = null;

        protected abstract T getThis();

        public T setConfigurationLoader(ConfigurationLoader<? extends ConfigurationNode> configurationLoader) {
            this.configurationLoader = configurationLoader;
            return this.getThis();
        }

        public T setConfigurationOptionsTransformer(Function<ConfigurationOptions, ConfigurationOptions> optionsTransformer) {
            Preconditions.checkNotNull(optionsTransformer);
            this.configurationOptionsTransformer = optionsTransformer;
            return this.getThis();
        }

        public T setLoggerProxy(LoggerProxy loggerProxy) {
            this.loggerProxy = loggerProxy;
            return this.getThis();
        }

        public T setOnPreEnable(Procedure onPreEnable) {
            Preconditions.checkNotNull((Object)onPreEnable);
            this.onPreEnable = onPreEnable;
            return this.getThis();
        }

        public T setOnEnable(Procedure onEnable) {
            Preconditions.checkNotNull((Object)onEnable);
            this.onEnable = onEnable;
            return this.getThis();
        }

        public T setOnPostEnable(Procedure onPostEnable) {
            Preconditions.checkNotNull((Object)onPostEnable);
            this.onPostEnable = onPostEnable;
            return this.getThis();
        }

        public T setModuleEnabler(ModuleEnabler enabler) {
            this.enabler = enabler;
            return this.getThis();
        }

        public T setRequireModuleDataAnnotation(boolean requireAnnotation) {
            this.requireAnnotation = requireAnnotation;
            return this.getThis();
        }

        public T setNoMergeIfPresent(boolean noMergeIfPresent) {
            this.doNotMerge = noMergeIfPresent;
            return this.getThis();
        }

        public T setModuleDescriptionHandler(@Nullable Function<Class<? extends Module>, String> handler) {
            this.moduleDescriptionHandler = handler;
            return this.getThis();
        }

        public T setModuleConfigurationHeader(@Nullable Function<Module, String> header) {
            this.moduleConfigurationHeader = header;
            return this.getThis();
        }

        public T setModuleConfigSectionName(String name) {
            Preconditions.checkNotNull((Object)name);
            this.moduleConfigSection = name;
            return this.getThis();
        }

        public T setModuleConfigSectionDescription(@Nullable String description) {
            this.moduleDescription = description;
            return this.getThis();
        }

        protected void checkBuild() {
            Preconditions.checkNotNull(this.configurationLoader);
            Preconditions.checkNotNull((Object)this.moduleConfigSection);
            if (this.loggerProxy == null) {
                this.loggerProxy = DefaultLogger.INSTANCE;
            }
            if (this.enabler == null) {
                this.enabler = ModuleEnabler.SIMPLE_INSTANCE;
            }
            Metadata.getStartupMessage().ifPresent(x -> this.loggerProxy.info((String)x));
        }

        public abstract R build() throws Exception;

        public final R build(boolean startDiscover) throws Exception {
            R build = this.build();
            if (startDiscover) {
                ((ModuleContainer)build).startDiscover();
            }
            return build;
        }
    }
}

