/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.LoggerProxy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.DoNotSave;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.LoadingStatus;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

@DoNotSave
public final class ModulesConfigAdapter
extends AbstractConfigAdapter<HashMap<String, LoadingStatus>> {
    public static final String modulesKey = "modules";
    private final TypeToken<Map<String, LoadingStatus>> tt = new TypeToken<Map<String, LoadingStatus>>(){};
    private final Map<String, LoadingStatus> defaults;
    private final LoggerProxy proxy;
    private final Map<String, String> descriptions;
    private final String key;
    private final String header;

    public ModulesConfigAdapter(Map<String, LoadingStatus> defaults, Map<String, String> descriptions, LoggerProxy proxy, String modulesKey, @Nullable String header) {
        this.defaults = defaults;
        this.descriptions = descriptions;
        this.proxy = proxy;
        this.key = modulesKey;
        this.header = header;
    }

    public final String getModulesKey() {
        return this.key;
    }

    @Override
    protected ConfigurationNode generateDefaults(ConfigurationNode node) {
        this.defaults.forEach((k, v) -> {
            String comment;
            node.getNode(new Object[]{k}).setValue((Object)v.name());
            if (node instanceof CommentedConfigurationNode && (comment = this.descriptions.get(k.toLowerCase())) != null && !comment.isEmpty()) {
                ((CommentedConfigurationNode)node).getNode(new Object[]{k}).setComment(comment);
            }
        });
        return node;
    }

    @Override
    protected HashMap<String, LoadingStatus> convertFromConfigurateNode(ConfigurationNode node) {
        HashMap value = null;
        try {
            value = (HashMap)node.getValue((TypeToken)new TypeToken<HashMap<String, LoadingStatus>>(){});
        }
        catch (ObjectMappingException e) {
            this.proxy.warn(e.getMessage());
        }
        if (value == null) {
            return Maps.newHashMap(this.defaults);
        }
        return value;
    }

    @Override
    protected ConfigurationNode insertIntoConfigurateNode(ConfigurationNode cn, HashMap<String, LoadingStatus> data) throws ObjectMappingException {
        cn.setValue(this.tt, data);
        if (cn instanceof CommentedConfigurationNode) {
            String h = this.header == null ? "Available modules to enable or disable. Set each to ENABLED to enable the module, DISABLED to prevent the module from loading or FORCELOAD to load the module even if something else tries to disable it." : this.header;
            ((CommentedConfigurationNode)cn).setComment(h);
        }
        return cn;
    }
}

