/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.modulecontainers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.LoggerProxy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleContainer;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleSpec;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Procedure;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleDiscoveryException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.ModuleConstructor;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.ModuleEnabler;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.SimpleModuleConstructor;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.modulecontainers.discoverystrategies.Strategy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.util.ThrownBiFunction;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public final class DiscoveryModuleContainer
extends ModuleContainer {
    private final ClassLoader classLoader;
    private final ModuleConstructor constructor;
    private final String packageLocation;
    private final Set<Class<?>> loadedClasses = Sets.newHashSet();
    private final Strategy strategy;

    public static Builder builder() {
        return new Builder();
    }

    private <N extends ConfigurationNode> DiscoveryModuleContainer(ConfigurationLoader<N> configurationLoader, ClassLoader loader, String packageBase, ModuleConstructor constructor, ModuleEnabler enabler, LoggerProxy loggerProxy, Procedure onPreEnable, Procedure onEnable, Procedure onPostEnable, Function<ConfigurationOptions, ConfigurationOptions> function, boolean requiresAnnotation, boolean processDoNotMerge, @Nullable Function<Module, String> headerProcessor, @Nullable Function<Class<? extends Module>, String> descriptionProcessor, String moduleSection, @Nullable String moduleSectionHeader, Strategy strategy) throws QuickStartModuleDiscoveryException {
        super(configurationLoader, loggerProxy, enabler, onPreEnable, onEnable, onPostEnable, function, requiresAnnotation, processDoNotMerge, headerProcessor, descriptionProcessor, moduleSection, moduleSectionHeader);
        this.classLoader = loader;
        this.constructor = constructor;
        this.packageLocation = packageBase;
        this.strategy = strategy;
    }

    @Override
    protected Set<Class<? extends Module>> discoverModules() throws Exception {
        this.loadedClasses.addAll(this.strategy.discover(this.packageLocation, this.classLoader));
        Set<Class<? extends Module>> modules = this.loadedClasses.stream().filter(Module.class::isAssignableFrom).map(x -> x.asSubclass(Module.class)).collect(Collectors.toSet());
        if (modules.isEmpty()) {
            throw new QuickStartModuleDiscoveryException("No modules were found", null);
        }
        return modules;
    }

    @Override
    protected Module getModule(ModuleSpec spec) throws Exception {
        return this.constructor.constructModule(spec.getModuleClass());
    }

    public final Set<Class<?>> getLoadedClasses() {
        return ImmutableSet.copyOf(this.loadedClasses);
    }

    @Deprecated
    public static enum DiscoveryStrategy implements ThrownBiFunction<String, ClassLoader, Set<Class<?>>, Exception>
    {
        DEFAULT{

            @Override
            public Set<Class<?>> apply(String s, ClassLoader classLoader) throws Exception {
                return Strategy.DEFAULT.discover(s, classLoader);
            }
        }
        ,
        FAST_CLASSPATH_SCANNER{

            @Override
            public Set<Class<?>> apply(String s, ClassLoader classLoader) throws Exception {
                return Strategy.DEFAULT.discover(s, classLoader);
            }
        }
        ,
        GOOGLE_REFLECT{

            @Override
            public Set<Class<?>> apply(String s, ClassLoader classLoader) throws Exception {
                return Strategy.DEFAULT.discover(s, classLoader);
            }
        };

    }

    public static final class Builder
    extends ModuleContainer.Builder<DiscoveryModuleContainer, Builder> {
        private String packageToScan;
        private ModuleConstructor constructor = SimpleModuleConstructor.INSTANCE;
        private ClassLoader classLoader;
        private Strategy strategy = Strategy.DEFAULT;

        public Builder setPackageToScan(String packageToScan) {
            this.packageToScan = packageToScan;
            return this;
        }

        public Builder setConstructor(ModuleConstructor constructor) {
            this.constructor = constructor;
            return this;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Deprecated
        public Builder setDiscoveryStrategy(ThrownBiFunction<String, ClassLoader, Set<Class<?>>, Exception> strategy) {
            Preconditions.checkNotNull(strategy);
            this.strategy = strategy::apply;
            return this;
        }

        public Builder setStrategy(Strategy strategy) {
            this.strategy = (Strategy)Preconditions.checkNotNull((Object)strategy);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public DiscoveryModuleContainer build() throws QuickStartModuleDiscoveryException {
            Preconditions.checkNotNull((Object)this.packageToScan);
            if (this.constructor == null) {
                this.constructor = SimpleModuleConstructor.INSTANCE;
            }
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            this.checkBuild();
            return new DiscoveryModuleContainer(this.configurationLoader, this.classLoader, this.packageToScan, this.constructor, this.enabler, this.loggerProxy, this.onPreEnable, this.onEnable, this.onPostEnable, this.configurationOptionsTransformer, this.requireAnnotation, this.doNotMerge, this.moduleConfigurationHeader, this.moduleDescriptionHandler, this.moduleConfigSection, this.moduleDescription, this.strategy);
        }
    }
}

