/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import java.util.List;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.SharedSubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class MetaUnsetTemp
extends SharedSubCommand {
    public MetaUnsetTemp(LocaleManager locale) {
        super(CommandSpec.META_UNSETTEMP.localize(locale), "unsettemp", CommandPermission.USER_META_UNSET_TEMP, CommandPermission.GROUP_META_UNSET_TEMP, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        String key = args.get(0);
        MutableContextSet context = ArgumentParser.parseContext(1, args, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)context) || ArgumentPermissions.checkArguments(plugin, sender, permission, key)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        if (holder.clearMetaKeys(key, context, true)) {
            Message.UNSET_META_TEMP_SUCCESS.send(sender, key, holder.getFormattedDisplayName(), MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
            ExtendedLogEntry.build().actor(sender).acted(holder).action("meta", "unsettemp", key, context).build().submit(plugin, sender);
            StorageAssistant.save(holder, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.DOESNT_HAVE_TEMP_META.send(sender, holder.getFormattedDisplayName(), key, MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
        return CommandResult.STATE_ERROR;
    }
}

