/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Predicates;

public class InfoCommand
extends SingleCommand {
    public InfoCommand(LocaleManager locale) {
        super(CommandSpec.INFO.localize(locale), "Info", CommandPermission.INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        Message.INFO_TOP.send(sender, plugin.getBootstrap().getVersion(), plugin.getBootstrap().getType().getFriendlyName(), plugin.getBootstrap().getServerBrand(), plugin.getBootstrap().getServerVersion());
        Message.INFO_STORAGE.send(sender, plugin.getStorage().getName());
        for (Map.Entry<String, String> e : plugin.getStorage().getMeta().entrySet()) {
            Message.INFO_STORAGE_META.send(sender, e.getKey(), InfoCommand.formatValue(e.getValue()));
        }
        Message.INFO_MIDDLE.send(sender, plugin.getMessagingService().map(InternalMessagingService::getName).orElse("None"), plugin.getContextManager().getStaticContextString().orElse("None"), plugin.getBootstrap().getPlayerCount(), plugin.getConnectionListener().getUniqueConnections().size(), DurationFormatter.CONCISE_LOW_ACCURACY.format((System.currentTimeMillis() - plugin.getBootstrap().getStartupTime()) / 1000L), plugin.getUserManager().getAll().size(), plugin.getGroupManager().getAll().size(), plugin.getTrackManager().getAll().size());
        return CommandResult.SUCCESS;
    }

    private static String formatValue(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return MessageUtils.formatBoolean(Boolean.parseBoolean(value));
        }
        try {
            int i = Integer.parseInt(value);
            return "&a" + i;
        }
        catch (NumberFormatException numberFormatException) {
            return "&f" + value;
        }
    }
}

