/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.managers.user;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.managers.AbstractManager;
import me.lucko.luckperms.common.managers.user.UserHousekeeper;
import me.lucko.luckperms.common.managers.user.UserManager;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public abstract class AbstractUserManager<T extends User>
extends AbstractManager<UserIdentifier, User, T>
implements UserManager<T> {
    private final LuckPermsPlugin plugin;
    private final UserHousekeeper housekeeper;

    public AbstractUserManager(LuckPermsPlugin plugin, UserHousekeeper.TimeoutSettings timeoutSettings) {
        this.plugin = plugin;
        this.housekeeper = new UserHousekeeper(plugin, this, timeoutSettings);
        this.plugin.getBootstrap().getScheduler().asyncRepeating(this.housekeeper, 10L, TimeUnit.SECONDS);
    }

    @Override
    public T getOrMake(UserIdentifier id) {
        User ret = (User)super.getOrMake(id);
        if (id.getUsername().isPresent()) {
            ret.setName(id.getUsername().get(), false);
        }
        return (T)ret;
    }

    @Override
    public T getByUsername(String name) {
        for (User user : this.getAll().values()) {
            Optional<String> n = user.getName();
            if (!n.isPresent() || !n.get().equalsIgnoreCase(name)) continue;
            return (T)user;
        }
        return null;
    }

    @Override
    public T getIfLoaded(UUID uuid) {
        return (T)((User)this.getIfLoaded(UserIdentifier.of(uuid, null)));
    }

    @Override
    public boolean giveDefaultIfNeeded(User user, boolean save) {
        boolean work = false;
        if (this.plugin.getConfiguration().get(ConfigKeys.PRIMARY_GROUP_CALCULATION_METHOD).equals("stored")) {
            String group;
            String pg = user.getPrimaryGroup().getValue();
            boolean has = false;
            for (Node node : user.enduringData().immutable().get((Object)ImmutableContextSet.empty())) {
                if (!node.isGroupNode() || !node.getGroupName().equalsIgnoreCase(pg)) continue;
                has = true;
                break;
            }
            if (!has && (group = (String)user.enduringData().immutable().get((Object)ImmutableContextSet.empty()).stream().filter(Node::isGroupNode).findFirst().map(Node::getGroupName).orElse(null)) != null) {
                user.getPrimaryGroup().setStoredValue(group);
                work = true;
            }
        }
        boolean hasGroup = false;
        if (user.getPrimaryGroup().getStoredValue().isPresent()) {
            for (Node node : user.enduringData().immutable().values()) {
                if (node.hasSpecificContext() || !node.isGroupNode()) continue;
                hasGroup = true;
                break;
            }
        }
        if (!hasGroup) {
            user.getPrimaryGroup().setStoredValue("default");
            user.setPermission(NodeFactory.buildGroupNode("default").build(), false);
            work = true;
        }
        if (work && save) {
            this.plugin.getStorage().saveUser(user);
        }
        return work;
    }

    @Override
    public UserHousekeeper getHouseKeeper() {
        return this.housekeeper;
    }

    @Override
    public void cleanup(User user) {
        this.housekeeper.cleanup(user.getId());
    }

    @Override
    public CompletableFuture<Void> updateAllUsers() {
        return CompletableFuture.runAsync(() -> this.plugin.getBootstrap().getOnlinePlayers().forEach(u -> this.plugin.getStorage().loadUser((UUID)u, null).join()), this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public void invalidateAllUserCaches() {
        this.getAll().values().forEach(PermissionHolder::invalidateCachedData);
    }

    @Override
    public boolean shouldSave(User user) {
        if (user.enduringData().immutable().size() != 1) {
            return true;
        }
        for (Node node : user.enduringData().immutable().values()) {
            if (!node.isGroupNode()) {
                return true;
            }
            if (node.isTemporary() || node.isServerSpecific() || node.isWorldSpecific()) {
                return true;
            }
            if (node.getGroupName().equalsIgnoreCase("default")) continue;
            return true;
        }
        return !user.getPrimaryGroup().getStoredValue().orElse("default").equalsIgnoreCase("default");
    }
}

