/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.metastacking;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.metastacking.MetaStackElement;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FluentMetaStackElement
implements MetaStackElement {
    private final List<MetaStackElement> subElements;
    private final String toString;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private FluentMetaStackElement(String name, Map<String, String> params, List<MetaStackElement> subElements) {
        this.subElements = ImmutableList.copyOf(subElements);
        this.toString = FluentMetaStackElement.formToString(name, params);
    }

    @Override
    public boolean shouldAccumulate(@NonNull LocalizedNode node, @NonNull ChatMetaType type, @Nullable Map.Entry<Integer, String> current) {
        for (MetaStackElement element : this.subElements) {
            if (element.shouldAccumulate(node, type, current)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluentMetaStackElement that = (FluentMetaStackElement)o;
        return this.subElements.equals(that.subElements);
    }

    public int hashCode() {
        return this.subElements.hashCode();
    }

    public String toString() {
        return this.toString;
    }

    private static String formToString(String name, Map<String, String> params) {
        return name + "(" + params.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).collect(Collectors.joining(", ")) + ")";
    }

    public static final class Builder {
        private final String name;
        private final ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        private final ImmutableList.Builder<MetaStackElement> elements = ImmutableList.builder();

        Builder(String name) {
            this.name = name;
        }

        public Builder with(MetaStackElement check) {
            this.elements.add((Object)check);
            return this;
        }

        public Builder param(String name, String value) {
            this.params.put((Object)name, (Object)value);
            return this;
        }

        public MetaStackElement build() {
            return new FluentMetaStackElement(this.name, (Map)this.params.build(), (List)this.elements.build());
        }
    }
}

